$(function (argument) {
    // Wysyłanie formularza paginacji.
    $('select[name=per_page]').change(function () {
        $(this).parent().submit();
    });

    // Edycja parametrów konfiguracyjnych w modalu.
    var $editModal = $('#edit-modal');

    $('.open-modal').click(function (e) {
        e.preventDefault();
        var $tr = $(this).parent().parent('tr');

        var $id = $('#edit_configuration_modal_id');
        var $groupName = $('#edit_configuration_modal_groupName');
        var $name = $('#edit_configuration_modal_name');
        var $value = $('#edit_configuration_modal_value');

        $id.val($tr.data('id'));
        $groupName.html($tr.data('group-name'));
        $name.html($tr.data('name'));
        $value.val($tr.find('input.value').val());
        $editModal.foundation('open');
    });

    var $editorHtml = $('.editor-html');

    if ($editorHtml.length) {
        var mixedMode = {
            name: "htmlmixed",
            scriptTypes: [
                {
                    matches: /\/x-handlebars-template|\/x-mustache/i,
                    mode: null
                },
                {
                    matches: /(text|application)\/(x-)?vb(a|script)/i,
                    mode: "vbscript"
                }
            ]
          };

        var myCodeMirror = CodeMirror.fromTextArea($editorHtml[0], {
            mode: mixedMode,
            lineNumbers: true,
        });
    }

    // Włączenie select2
    if($('.select2cookie').length>0){
        $('.select2cookie').select2({
            allowClear: false,
            width: 'resolve'
        });
    }

    // Włączenie tinyMCE dla komunikatu o cookies
    if($('.tinyMCEcookieContent').length>0){
        tinymce.init({
            selector: ".tinyMCEcookieContent",  // change this value according to your HTML
            menubar: false,
            plugins: [
                "advlist autolink lists charmap print preview hr anchor pagebreak",
                "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                "save table contextmenu directionality template link image paste textcolor"
            ],
            height: '100',
            toolbar1: "insertfile undo redo | styleselect | bold italic underline | alignleft aligncenter alignright alignjustify | numlist outdent indent | link | preview | forecolor backcolor fontsizeselect | code",
        });
    }

    // wyłączanie ustawień, jeśli cookies jest wyłączone
    $('.switchCookieEnable').change(function () {
        if (this.checked) {
            $('.enabledCookies').css({
                'opacity': '1',
                'pointer-events': 'all'
            });
        } else {
            $('.enabledCookies').css({
                'opacity': '0.5',
                'pointer-events': 'none'
            });
        }
    });

    if ($('.switchCookieEnable:checked').length > 0) {
        $('.enabledCookies').css({
            'opacity': '1',
            'pointer-events': 'all'
        });
    } else {
        $('.enabledCookies').css({
            'opacity': '0.5',
            'pointer-events': 'none'
        });
    }

    // Konfiguracja komentarzy.
    var $commentEnable = $('#config_comment_edit_comment_enable');

    if ($commentEnable.length > 0) {
        $commentEnable.change(function (e) {
            var val = $(this).val();
            var $wicmsBlock = $('#comment-engine-wicms');
            var $disqusBlock = $('#comment-engine-disqus');
            var $facebookBlock = $('#comment-engine-facebook');

            switch (val) {
                case 'wicms':
                    $wicmsBlock.show();
                    $disqusBlock.hide();
                    $facebookBlock.hide();
                    break;
                case 'facebook':
                    $wicmsBlock.hide();
                    $disqusBlock.hide();
                    $facebookBlock.show();
                    break;
                case 'disqus':
                    $wicmsBlock.hide();
                    $disqusBlock.show();
                    $facebookBlock.hide();
                    break;
                default:
                    $wicmsBlock.hide();
                    $disqusBlock.hide();
                    $facebookBlock.hide();
                    break;
            }
        }).change();
    }

    // Włączenie Select2.
    if ($('.chosenSelectCategory').length > 0) {
        $('.chosenSelectCategory').select2();
    }
});
