$(function () {
    'use strict';

    showUtm();
    $('.switch-input.new').click(function () {
        showUtm();
    });

    function showUtm() {
        if ($('.switch-input.new')[0].checked) {
            $('#short-link-utm').slideDown();
            $('#wi_admin_linkbundle_link_utmSource').prop('required', true);
            $('#wi_admin_linkbundle_link_utmMedium').prop('required', true);
            $('#wi_admin_linkbundle_link_utmSource').val(window.location.host)
            $('#wi_admin_linkbundle_link_utmMedium').val('link')
        } else {
            $('#short-link-utm').slideUp();
            $('#wi_admin_linkbundle_link_utmSource').prop('required', false);
            $('#wi_admin_linkbundle_link_utmMedium').prop('required', false);
            $('#wi_admin_linkbundle_link_utmSource').val('')
            $('#wi_admin_linkbundle_link_utmMedium').val('')
        }
    }

    $('#wi_admin_linkbundle_link_url').each(function () {
        var $elem = $(this);

        $elem.bind('propertychange change click keyup input paste', function (e) {
            var value = $elem.val();
            $('#preview_utm_url').data('val', value);
            $('#preview_utm_url').val(value);
            updatePreveiw();
        });
    });

    $('.utm-preview').each(function () {
        var $elem = $(this);

        $elem.bind('propertychange change click keyup input paste', function (e) {
            updatePreveiw();
        });
    });

    function updatePreveiw() {
        var $source = $('#wi_admin_linkbundle_link_utmSource');
        var $medium = $('#wi_admin_linkbundle_link_utmMedium');
        var $name = $('#wi_admin_linkbundle_link_utmName');
        var $term = $('#wi_admin_linkbundle_link_utmTerm');
        var $content = $('#wi_admin_linkbundle_link_utmContent');
        var utmValue = '';

        if ($source.val() != '' && $('#preview_utm_url').data('val') != '') {
            var sourceParam = '?utm_source=' + encodeURIComponent($source.val());
            var mediumParam = $medium.val() ? '&utm_medium=' + encodeURIComponent($medium.val()) : '';
            var nameParam = $name.val() ? '&utm_campaign=' + encodeURIComponent($name.val()) : '';
            var termParam = $term.val() ? '&utm_term=' + encodeURIComponent($term.val()) : '';
            var contentParam = $content.val() ? '&utm_content=' + encodeURIComponent($content.val()) : '';

            utmValue = sourceParam+mediumParam+nameParam+termParam+contentParam;
        }

        $('#preview_utm_url').val($('#preview_utm_url').data('val')+utmValue);
    }

    var $editModal = $('#edit-modal');

    $('.open-modal').click(function (e) {
        e.preventDefault();
        var $tr = $(this).parents('tr');

        var $id = $('#wi_admin_linkbundle_link_edit_id');
        var $url = $('#wi_admin_linkbundle_link_edit_url');
        var $utmEnable = $('#wi_admin_linkbundle_link_edit_utmEnable');
        var $utmSource = $('#wi_admin_linkbundle_link_edit_utmSource');
        var $utmMedium = $('#wi_admin_linkbundle_link_edit_utmMedium');
        var $utmName = $('#wi_admin_linkbundle_link_edit_utmName');
        var $utmTerm = $('#wi_admin_linkbundle_link_edit_utmTerm');
        var $utmContent = $('#wi_admin_linkbundle_link_edit_utmContent');

        $id.val($tr.data('id'));
        $url.val($tr.data('url'));
        $utmSource.val($tr.data('utm-source'));
        $utmMedium.val($tr.data('utm-medium'));
        $utmName.val($tr.data('utm-name'));
        $utmTerm.val($tr.data('utm-term'));
        $utmContent.val($tr.data('utm-content'));
        console.log($utmEnable);
        $tr.data('utm-enable') ? $utmEnable[0].checked = true : $utmEnable[0].checked = false;
        showUtmEdit();
        $editModal.foundation('open');
    });

    $('.switch-input.edit').click(function () {
        showUtmEdit();
    });

    function showUtmEdit() {
        if ($('.switch-input.edit')[0].checked) {
            $('#short-link-utm-edit').slideDown();
            $('#wi_admin_linkbundle_link_edit_utmSource').prop('required', true);
            $('#wi_admin_linkbundle_link_edit_utmMedium').prop('required', true);
        } else {
            $('#short-link-utm-edit').slideUp();
            $('#wi_admin_linkbundle_link_edit_utmSource').prop('required', false);
            $('#wi_admin_linkbundle_link_edit_utmMedium').prop('required', false);
        }
    }
});
