<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_admin_administrators_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.adminDelete')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/admin.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.administration'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.Administrators'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_admin_administrators_delete', array('id' => $administrator->getid())); ?>"><?php echo $view['translator']->trans('breadcrumbs.AdminDelete'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('admin.listTitle'); ?> - <?php echo $view['translator']->trans('adminDelete.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-users-outline color-menu-administration"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('adminDelete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-user-outline"></i>
                <span><?php echo $view['translator']->trans('adminDelete.listSubTitle'); ?> - <?php echo(!empty($administrator->getfirstName()) ? $administrator->getfirstName() . ' ' . $administrator->getlastName() : $administrator->getlogin()); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-12 columns">
                    <p><strong><?php echo $view['translator']->trans('adminDelete.dataAdmin'); ?></strong></p>
                    <?php echo $view['form']->start($formDelete); ?>
                        <?php echo $view['form']->errors($formDelete); ?>
                        <div class="switch-admin">
                            <?php echo $view['form']->errors($formDelete['deleteAdmin']); ?>
                            <?php echo $view['form']->widget($formDelete['deleteAdmin']); ?>
                            <label class="switch-paddle" for="<?php echo $formDelete->children['deleteAdmin']->vars['id']; ?>">
                                <span class="show-for-sr"><?php echo $view['translator']->trans('adminDelete.dataAdmin'); ?></span>
                                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                            </label>
                        </div>
                        <p><?php echo $view['translator']->trans('adminDelete.dataAdminSub'); ?>:<br>
                        <strong><?php echo $view['translator']->trans('adminData.login'); ?></strong> <?php echo $administrator->getlogin() ?><br>
                            <strong><?php echo $view['translator']->trans('adminData.Name'); ?></strong> <?php echo $administrator->getfirstName() . ' ' . $administrator->getlastName() ?><br>
                            <strong><?php echo $view['translator']->trans('adminData.email'); ?></strong> <?php echo $administrator->getemail() ?></p>
                        <button type="submit" id="AdminDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                            <i class="icon-cancel-circled"></i>
                            <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                        </button>
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_admin_administrators_show', array('id' => $administrator->getId())); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                        </a>
                    <?php echo $view['form']->end($formDelete); ?>
                </div>

            </div>


        </div>
        <!-- end .timeline -->
    </div>
    <!-- box -->


<?php $view['slots']->stop() ?>


<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/admin.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
