<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_banner_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.bannerSet.List')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/banner.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li><?php echo $view['translator']->trans('main-menu.template_extension'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_banner_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.bannerSet.List'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
<?php echo $view['translator']->trans('banner.listTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-exchange-1 color-menu-template-extension"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
<?php echo $view['translator']->trans('bannerList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>

    <div class="box manageBlocks">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="configCategory-dropdown">
                 <i class="icon-ellipsis-vert"></i>
            </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configCategory-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_bannerSet_new') ?>"  title="<?php echo $view['translator']->trans('bannerSetList.addNewBannerSet'); ?>">
                                    <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('bannerSetList.addNewBannerSet'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_bannerSet_index') ?>" title="<?php echo $view['translator']->trans('bannerSetList.manageBannerSet'); ?>">
                                <span><i class="icon-folder-2"></i> <?php echo $view['translator']->trans('bannerSetList.manageBannerSet'); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-cog-5"></i>
                <span><?php echo $view['translator']->trans('bannerSetList.manageBar'); ?></span>
            </h3>
        </div>
    </div>
    <?php foreach($bannerSet as $key =>  $singleSet): ?>
    <div class="boxPagesGroup box">
       <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('wi_admin_banner_new', ['bannerset_id' => $singleSet->getId()]);?>" title="<?php echo $view['translator']->trans('bannerList.addNewBanner'); ?>" class="button tiny primary buttonAddNew">
                        <i class="icon-folder-add"></i>
                        <?php echo $view['translator']->trans('bannerList.addNewBanner'); ?>
                    </a>
                <?php endif; ?>
                <span class="box-btn" data-toggle="configPagesGroup<?php echo $singleSet->getId()?>-dropdown">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="left" id="configPagesGroup<?php echo $singleSet->getId()?>-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_banner_new', ['bannerset_id' => $singleSet->getId()]);?>" title="<?php echo $view['translator']->trans('bannerList.addNewBanner'); ?>">
                                    <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('bannerList.addNewBanner'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT') & $key != 0): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_bannerSet_delete', ['id' => $singleSet->getId()]) ?>" class="">
                                    <span><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('bannerSetDelete.Delete2'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="odciecie">
                            <button class="collapseAll" type="button">
                                <span><i class="icon-collapse"></i><?php echo $view['translator']->trans('pagesList.collapse')?></span>
                            </button>
                        </li>
                        <li class="odciecie">
                            <button class="expandAll" type="button">
                                <span><i class="icon-expand"></i><?php echo $view['translator']->trans('pagesList.expand')?></span>
                            </button>
                        </li>
                    </ul>
                </div>
                <span>
                    <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-menu-outline"></i>
                <span><?php echo $singleSet->getName() ?> (<?php echo $singleSet->getBanners()->count(); ?>)</span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: <?php ($key == 0 ? 'bannerSet' : 'none')?>">
            <br>
            <div class="row">
                <div class="columns tableResp">
                    <table id="itemHTMLGroupTable" class="itemHTMLTable">
                        <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('bannerSetList.thumbnail'); ?></th>
                            <th><?php echo $view['translator']->trans('bannerForm.content'); ?></th>
                            <th><?php echo $view['translator']->trans('bannerForm.orderNr'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php foreach($singleSet->getBanners() as $key => $banner): ?>
                            <tr>
                                <td>
                                    <div class="imgThmbnail" placeholder="no image">
                                        <?php if ($banner->getImageURL()): ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_banner_show', ['id' => $banner->getId()]); ?>">
                                            <img class="imgListNews thumbnail banner" src="<?php echo $view['assets']->getUrl('media/assets/Banner/'.$banner->getImageURL()); ?>">
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td>
                                    <div class="callout itemHtml">
                                        <?php echo $banner->getContent() ?>
                                        <div class="buttonItemsBox">
                                            <div class="buttonsItems">
                                                <a href="<?php echo $view['router']->path('wi_admin_banner_show', ['id' => $banner->getId()]) ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton') ?></a>
                                                <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')) { ?>
                                                    <a href="<?php echo $view['router']->path('wi_admin_banner_edit', ['id' => $banner->getId()]) ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton') ?></a>
                                                <?php } ?>
                                                <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')) { ?>
                                                    <a href="<?php echo $view['router']->path('wi_admin_banner_delete', ['id' => $banner->getId()]) ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton') ?></a>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="OrderNrForm">
                                        <?php if (! is_null($singleSet->getBanners()->get($key - 1))): ?>
                                            <div><a href="<?php echo $view['router']->path('wi_admin_banner_update_order', ['id' => $banner->getId(), 'sort_dir' => 'up']) ?>" class="button secondary tiny"><i class="icon-up-big margin-center"></i></a></div>
                                        <?php else: ?>
                                            <div><span class="button disabled secondary tiny"><i class="icon-up-big margin-center"></i></span></div>
                                        <?php endif; ?>
                                        <?php if (! is_null($singleSet->getBanners()->get($key + 1))): ?>
                                            <div><a href="<?php echo $view['router']->path('wi_admin_banner_update_order', ['id' => $banner->getId(), 'sort_dir' => 'down']); ?>" class="button secondary tiny"><i class="icon-down-big margin-center"></i></a></div>
                                        <?php else: ?>
                                            <div><span class="button disabled secondary tiny"><i class="icon-down-big margin-center"></i></span></div>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                   </table>
                </div>
                <!--<hr>-->
            </div>
            <?php if($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                <div class="row columns addNewPage">
                    <a href="<?php echo $view['router']->path('wi_admin_banner_new', ['bannerset_id' => $singleSet->getId()]);?>" class="button" title="<?php $view['translator']->trans('bannerList.addInGr')?>"><?php echo $view['translator']->trans('bannerList.add'); ?></a>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php $i=1; endforeach; ?>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/banner.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
