<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_banner_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.bannerSet.List')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/banner.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li><?php echo $view['translator']->trans('main-menu.template_extension'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_banner_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.bannerSet.List'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_bannerSet_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.bannerSet.bannerSet'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('bannerSet.listTitle'); ?> - <?php echo $view['translator']->trans('bannerSetList.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-exchange-1 color-menu-template-extension"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('bannerSetList.desc'); ?>
<?php $view['slots']->stop() ?>    
    
<?php $view['slots']->start('body') ?>
    
    <div class="box">
       <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('wi_admin_bannerSet_new'); ?>" title="<?php echo $view['translator']->trans('bannerSetList.addNewBannerSet'); ?>" class="button tiny primary buttonAddNew">
                        <i class="icon-edit"></i>
                        <?php echo $view['translator']->trans('bannerSetList.addNewBannerSet'); ?>
                    </a>
                <?php endif; ?>
            </div>
            <h3 class="box-title"><i class="icon-newspaper-1"></i>
                <span><?php echo $view['translator']->trans('bannerSetList.listSubTitle')?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display:bannerSet;">
            <div class="row">
                <div class="columns tableResp">
                    <table id="itemHTMLGroupTable" class="bannerSetList" style="width:100%">
                        <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('bannerSetNew.form.nameTitle')?></th>
                            <th><?php echo $view['translator']->trans('bannerSetList.bannerSetList')?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($bannerSet as $key => $singleSet): ?>
                                <tr>  
                                    <td><a href="<?php echo $view['router']->path('wi_admin_bannerSet_show', ['id' => $singleSet->getId()]); ?>"><b><?php echo $singleSet->getName(); ?></b></a>
                                        <div class="buttonItemsBox">
                                            <div class="buttonsItems">
                                                 <a href="<?php echo $view['router']->path('wi_admin_bannerSet_show', ['id' => $singleSet->getId()]) ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton') ?></a>
                                                <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT') & $key != 0): ?>
                                                    <a href="<?php echo $view['router']->path('wi_admin_bannerSet_edit', ['id' => $singleSet->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a>
                                                <?php endif; ?>
                                                <?php if ($view['security']->isGranted('ROLE_BANNER_EDIT') & $key != 0): ?>
                                                    <a href="<?php echo $view['router']->path('wi_admin_bannerSet_delete', ['id' => $singleSet->getId()]); ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                                <?php endif; ?>
                                            </div>
                                        </div></td>
                                    <td class="showItemBlock">
                                        <div class="tiny button-group">
                                            <?php foreach ($singleSet->getBanners() as $banner): ?>
                                                <span class="info label secondary showItemButton"><?php echo $banner->getImageURL(); ?></span>
                                            <?php endforeach; ?>
                                        </div>
                                    </td>
                                </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div> 
            <div class="row bannerSetHTMLButton">
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_banner_index'); ?>">
                    <i class="icon-reply"></i><?php echo $view['translator']->trans('bannerSetList.backButton'); ?>
                </a>
            </div>
        </div>    
    </div>  
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
    
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/banner.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>