<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('admin_wicms_blocked_index'));

/** @var \Knp\Bundle\PaginatorBundle\Templating\PaginationHelper $pagination */
$pagination = $view['knp_pagination'];
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];

$view['slots']->set('title', $translator->trans('title.blocked.index', [], 'blocked'));
$view['slots']->set('titleSite', $translator->trans('blocked.index.title', [], 'blocked'));
$view['slots']->set('titleDesc', $translator->trans('blocked.index.desc', [], 'blocked'));
$view['slots']->set('titleIcon', '<i class="icon-block-4 color-menu-administration"></i>');
$view['slots']->set('helpRightPanel', '');
?>
<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $translator->trans('main-menu.administration'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_wicms_blocked_index'); ?>"><?php echo $translator->trans('breadcrumbs.blocked.index', [], 'blocked'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <a class="button tiny ip-modal-open" data-id><i class="icon-plus-squared-1"></i> <?php echo $translator->trans('blocked.form.new', [], 'blocked'); ?></a>
        </div>
        <h3 class="box-title">
            <i class="icon-block-4"></i> <span><?php echo $translator->trans('blocked.index.subtitle', [], 'blocked'); ?></span>
        </h3>
    </div>
    <div class="box-body">
        <div class="row">
            <div class="columns tableResp">
                <table id="blockedTable" class="display" style="width:100%">
                    <thead>
                    <tr>
                        <th><?php echo $pagination->sortable($blockedIps, $translator->trans('blocked.table.id', [], 'blocked'), 'i.id'); ?></th>
                        <th><?php echo $pagination->sortable($blockedIps, $translator->trans('blocked.table.ip', [], 'blocked'), 'i.ip'); ?></th>
                        <th><?php echo $pagination->sortable($blockedIps, $translator->trans('blocked.table.created_at', [], 'blocked'), 'i.createdAt'); ?></th>
                        <th><?php echo $pagination->sortable($blockedIps, $translator->trans('blocked.table.expired_at', [], 'blocked'), 'i.expiredAt'); ?></th>
                        <th><?php echo $pagination->sortable($blockedIps, $translator->trans('blocked.table.permanent', [], 'blocked'), 'i.permanent'); ?></th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php /** @var \Admin\WicmsBundle\Entity\Ip $blockedIp */
                    foreach ($blockedIps as $blockedIp): ?>
                        <tr>
                            <td><?php echo $blockedIp->getId(); ?></td>
                            <td><?php echo $blockedIp->getIpAddress(); ?></td>
                            <td><?php echo $blockedIp->getCreatedAt()->format('H:i:s d.m.Y'); ?></td>
                            <td><?php echo $blockedIp->getExpiredAtFormatted(); ?></td>
                            <td><?php echo $blockedIp->getPermanent() ? $translator->trans('yes') : $translator->trans('no'); ?></td>
                            <td style="font-size:12px;">
                                <a class="ip-modal-open" data-id="<?php echo $blockedIp->getId(); ?>"><i class="icon-edit-1"></i> <?php echo $translator->trans('blocked.form.edit', [], 'blocked'); ?></a>
                                | <a href="<?php echo $view['router']->url('admin_wicms_blocked_delete', ['id' => $blockedIp->getId()]); ?>" class="confirm" data-ip="<?php echo $blockedIp->getIpAddress(); ?>"><i class="icon-cancel-circled-outline"></i> <?php echo $translator->trans('blocked.form.delete', [], 'blocked'); ?></a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
                <div class="paginationBox">
                    <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                        'knp_pagination' => $blockedIps,
                    ]); ?>

                    <?php echo $view['knp_pagination']->render($blockedIps); ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="reveal tiny" id="ip-new-edit-modal" data-reveal></div>

<script>var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';</script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/blocked.js'); ?>"></script>
<script>
    $('.ip-modal-open').click(function (e) {
        e.preventDefault();

        modal(this);
    });

    function modal(current) {
        var id = $(current).data('id');
        var dataUrl = Routing.generate('admin_wicms_blocked_modal', { id: id });

        $('#ip-new-edit-modal').load(dataUrl, function (e) {
            $(this).foundation('open');

            $('#ip-new-edit-modal form[name="ip"]').on('change', '#ip_permanent', function (e) {
                if ($(this).is(':checked')) {
                    $('#ip_expiredAt').attr('required', false);
                } else {
                    $('#ip_expiredAt').attr('required', true);
                }
            });

            if ($('#ip_permanent').is(':checked')) {
                $('#ip_expiredAt').attr('required', false);
            } else {
                $('#ip_expiredAt').attr('required', true);
            }

            $(this).unbind('submit').on('submit', 'form', function (e) {
                e.preventDefault();

                $.ajax({
                    url: dataUrl,
                    type: 'POST',
                    data: $('#ip-new-edit-modal form[name="ip"]').serialize(),
                    success: function (response, status, xhr) {
                        if (xhr.status == 201) {
                            $('#ip-new-edit-modal').foundation('close');
                            window.location.reload();
                        } else {
                            $('#ip-new-edit-modal').html(response);
                        }
                    }
                })
            });
        });
    }

    var $confirm = $('.confirm');

    if ($confirm.length > 0) {
        $confirm.click(function (e) {
            return confirm("<?php echo $view['translator']->trans('blocked.form.delete_confirm_ip', [], 'blocked'); ?>: " + $(this).data('ip') + "?");
        });
    }
</script>
<?php $view['slots']->stop(); ?>
