<div class="box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
        </div>
        <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
            <span><?php echo $view['translator']->trans('newsletter.blocks.logs'); ?></span>
        </h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns end tableResp">
                <table id="logsInfo" class="table-config tableResp" style="width:100%">
                    <thead>
                    <tr>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.date'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.recipient'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.sender'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.campaign'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.message'); ?></th>
                        <th><?php echo $view['translator']->trans('newsletter.blockContent.logs.status'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($logs as $log): ?>
                        <tr>
                            <td style="padding-left: 10px !important; white-space: nowrap;"><a href="<?php echo $view['router']->path('wi_admin_newsletter_logs_show', ['id' => $log->getId()]) ?>" class=""><?php echo $log->getDateMessage()->format('Y-m-d H:i:s'); ?></a></td>
                            <td><?php echo ($recipient = $log->getRecipient()) ? $recipient->getEmail() : null; ?></td>
                            <td><?php echo ($sender = $log->getSender()) ? $sender->getEmail() : null; ?></td>
                            <td><?php echo ($campaign = $log->getCampaign()) ? $campaign->getName() : null; ?></td>
                            <td><?php echo ($messageContent = $log->getMessageContent()) ? $messageContent->getTitle() : null; ?></td>
                            <td class="langStyle"><?php echo $log->getStatus(); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="medium-12 columns paginationBox">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page_logs.html.php', [
                    'knp_pagination' => $logs,
                ]); ?>

                <?php echo $view['knp_pagination']->render($logs); ?>
            </div>
        </div>
    </div>
</div>
