<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_config_gallery')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('configuration.meta.title', [], 'config')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/configuration.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.configuration.title'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_core_config_gallery'); ?>"><?php echo $view['translator']->trans('breadcrumbs.configuration_gallery', [], 'config'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('configuration.gallery.title', [], 'config'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-camera-1 color-menu-configuration"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('helpRightPanel') ?><?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-cogs"></i>
                <span><?php echo $view['translator']->trans('configuration.gallery.title', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.gallery.image.main.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.gallery.image.main.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-4 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['gallery_imageWidth']); ?>
                        <?php echo $view['form']->errors($form['gallery_imageHeight']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['gallery_imageWidth'], [
                        'attr' => [
                            'class' => $form['gallery_imageWidth']->vars['attr']['class'] . (! $form['gallery_imageWidth']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                     x
                    <?php echo $view['form']->widget($form['gallery_imageHeight'], [
                        'attr' => [
                            'class' => $form['gallery_imageHeight']->vars['attr']['class'] . (! $form['gallery_imageHeight']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?> px
                </div>
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.gallery.image.main.quality.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.gallery.image.main.quality.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-4 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['gallery_imageQuality']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['gallery_imageQuality'], [
                        'attr' => [
                            'class' => $form['gallery_imageQuality']->vars['attr']['class'] . (! $form['gallery_imageQuality']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                </div>

            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.gallery.image.thumbnail.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.gallery.image.thumbnail.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['gallery_thumbnailWidth']); ?>
                        <?php echo $view['form']->errors($form['gallery_thumbnailHeight']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['gallery_thumbnailWidth'], [
                        'attr' => [
                            'class' => $form['gallery_thumbnailWidth']->vars['attr']['class'] . (! $form['gallery_thumbnailWidth']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                     x
                    <?php echo $view['form']->widget($form['gallery_thumbnailHeight'], [
                        'attr' => [
                            'class' => $form['gallery_thumbnailHeight']->vars['attr']['class'] . (! $form['gallery_thumbnailHeight']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?> px
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.gallery.image.thumbnailS.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.gallery.image.thumbnailS.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['gallery_thumbnailSWidth']); ?>
                        <?php echo $view['form']->errors($form['gallery_thumbnailSHeight']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['gallery_thumbnailSWidth'], [
                        'attr' => [
                            'class' => $form['gallery_thumbnailSWidth']->vars['attr']['class'] . (! $form['gallery_thumbnailSWidth']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                     x
                    <?php echo $view['form']->widget($form['gallery_thumbnailSHeight'], [
                        'attr' => [
                            'class' => $form['gallery_thumbnailSHeight']->vars['attr']['class'] . (! $form['gallery_thumbnailSHeight']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?> px
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.gallery.image.cover.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.gallery.image.cover.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['gallery_coverWidth']); ?>
                        <?php echo $view['form']->errors($form['gallery_coverHeight']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['gallery_coverWidth'], [
                        'attr' => [
                            'class' => $form['gallery_coverWidth']->vars['attr']['class'] . (! $form['gallery_coverWidth']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                     x
                    <?php echo $view['form']->widget($form['gallery_coverHeight'], [
                        'attr' => [
                            'class' => $form['gallery_coverHeight']->vars['attr']['class'] . (! $form['gallery_coverHeight']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?> px
                </div>
            </div>
        </div>
    </div>
<button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
    <i class="icon-edit"></i>
    <?php echo $view['translator']->trans('Form.send'); ?>
</button>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/configuration.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
