<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_core_config_news')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('configuration.meta.title', [], 'config')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/configuration.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.configuration.title'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_core_config_news'); ?>"><?php echo $view['translator']->trans('breadcrumbs.configuration_news', [], 'config'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('configuration.news.title', [], 'config'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-comment-alt-1 color-menu-configuration"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>

<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title"><i class="icon-cogs"></i>
                <span><?php echo $view['translator']->trans('configuration.news.titleNews', [], 'config'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.news.image.main.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.news.image.main.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['news_imageWidth']); ?>
                        <?php echo $view['form']->errors($form['news_imageHeight']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['news_imageWidth'], [
                        'attr' => [
                            'class' => $form['news_imageWidth']->vars['attr']['class'] . (! $form['news_imageWidth']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                     x
                    <?php echo $view['form']->widget($form['news_imageHeight'], [
                        'attr' => [
                            'class' => $form['news_imageHeight']->vars['attr']['class'] . (! $form['news_imageHeight']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?> px
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.news.image.thumbnail.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.news.image.thumbnail.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['news_thumbnailWidth']); ?>
                        <?php echo $view['form']->errors($form['news_thumbnailHeight']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['news_thumbnailWidth'], [
                        'attr' => [
                            'class' => $form['news_thumbnailWidth']->vars['attr']['class'] . (! $form['news_thumbnailWidth']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                     x
                    <?php echo $view['form']->widget($form['news_thumbnailHeight'], [
                        'attr' => [
                            'class' => $form['news_thumbnailHeight']->vars['attr']['class'] . (! $form['news_thumbnailHeight']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?> px
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('configuration.news.image.thumbnailS.title', [], 'config'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.news.image.thumbnailS.desc', [], 'config'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="formAlert">
                        <?php echo $view['form']->errors($form['news_thumbnailSWidth']); ?>
                        <?php echo $view['form']->errors($form['news_thumbnailSHeight']); ?>
                    </div>
                    <?php echo $view['form']->widget($form['news_thumbnailSWidth'], [
                        'attr' => [
                            'class' => $form['news_thumbnailSWidth']->vars['attr']['class'] . (! $form['news_thumbnailSWidth']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>
                     x
                    <?php echo $view['form']->widget($form['news_thumbnailSHeight'], [
                        'attr' => [
                            'class' => $form['news_thumbnailSHeight']->vars['attr']['class'] . (! $form['news_thumbnailSHeight']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?> px
                </div>
            </div>

            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
        </div>
    </div>
<?php echo $view['form']->end($form); ?>

<?php echo $view['form']->start($formBlog); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-cogs"></i>
            <span><?php echo $view['translator']->trans('configuration.blog.titleBlog', [], 'config'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('configuration.blog.image.main.title', [], 'config'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.blog.image.main.desc', [], 'config'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert">
                    <?php echo $view['form']->errors($formBlog['blog_imageWidth']); ?>
                    <?php echo $view['form']->errors($formBlog['blog_imageHeight']); ?>
                </div>
                <?php echo $view['form']->widget($formBlog['blog_imageWidth'], [
                    'attr' => [
                        'class' => $formBlog['blog_imageWidth']->vars['attr']['class'] . (! $formBlog['blog_imageWidth']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
                x
                <?php echo $view['form']->widget($formBlog['blog_imageHeight'], [
                    'attr' => [
                        'class' => $formBlog['blog_imageHeight']->vars['attr']['class'] . (! $formBlog['blog_imageHeight']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?> px
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('configuration.blog.image.thumbnail.title', [], 'config'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.blog.image.thumbnail.desc', [], 'config'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert">
                    <?php echo $view['form']->errors($formBlog['blog_thumbnailWidth']); ?>
                    <?php echo $view['form']->errors($formBlog['blog_thumbnailHeight']); ?>
                </div>
                <?php echo $view['form']->widget($formBlog['blog_thumbnailWidth'], [
                    'attr' => [
                        'class' => $formBlog['blog_thumbnailWidth']->vars['attr']['class'] . (! $formBlog['blog_thumbnailWidth']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
                x
                <?php echo $view['form']->widget($formBlog['blog_thumbnailHeight'], [
                    'attr' => [
                        'class' => $formBlog['blog_thumbnailHeight']->vars['attr']['class'] . (! $formBlog['blog_thumbnailHeight']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?> px
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('configuration.blog.image.thumbnailS.title', [], 'config'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('configuration.blog.image.thumbnailS.desc', [], 'config'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert">
                    <?php echo $view['form']->errors($formBlog['blog_thumbnailSWidth']); ?>
                    <?php echo $view['form']->errors($formBlog['blog_thumbnailSHeight']); ?>
                </div>
                <?php echo $view['form']->widget($formBlog['blog_thumbnailSWidth'], [
                    'attr' => [
                        'class' => $formBlog['blog_thumbnailSWidth']->vars['attr']['class'] . (! $formBlog['blog_thumbnailSWidth']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
                x
                <?php echo $view['form']->widget($formBlog['blog_thumbnailSHeight'], [
                    'attr' => [
                        'class' => $formBlog['blog_thumbnailSHeight']->vars['attr']['class'] . (! $formBlog['blog_thumbnailSHeight']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?> px
            </div>
        </div>

        <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
            <i class="icon-edit"></i>
            <?php echo $view['translator']->trans('Form.send'); ?>
        </button>
    </div>
</div>
<?php echo $view['form']->end($formBlog); ?>

<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/configuration.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
