<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_department_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.department.new', [], 'department')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/department.css') ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><?php echo $view['translator']->trans('main-menu.administration'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_department_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.department.index', [], 'department'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_department_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.department.new', [], 'department'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?><?php echo $view['translator']->trans('department.index.title', [], 'department'); ?> - <?php echo $view['translator']->trans('department.new.title', [], 'department'); ?><?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleDesc'); ?><?php echo $view['translator']->trans('department.new.desc', [], 'department'); ?><?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon'); ?><i class="icon-th-list-2 color-menu-administration"></i><?php $view['slots']->stop(); ?>
<?php $view['slots']->start('helpRightPanel'); ?><?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <h3 class="box-title">
                <i class="icon-th-list-2"></i><span><?php echo $view['translator']->trans('department.new.subtitle', [], 'department'); ?></span>
            </h3>
        </div>
        <div class="box-body" style="display:block;">
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong><?php echo $view['translator']->trans('department.form.title.title', [], 'department'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('department.form.title.desc', [], 'department'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert"><?php echo $view['form']->errors($form['title']); ?></div>
                            <?php echo $view['form']->widget($form['title'], [
                                'attr' => [
                                    'class' => ($form['title']->vars['attr']['class'] ?? '') . (! $form['title']->vars['valid'] ? ' callout alert' : null),
                                ],
                            ]); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong><?php echo $view['translator']->trans('department.form.parent.title', [], 'department'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('department.form.parent.desc', [], 'department'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert"><?php echo $view['form']->errors($form['parent']); ?></div>
                            <?php echo $view['form']->widget($form['parent'], [
                                'attr' => [
                                    'class' => ($form['parent']->vars['attr']['class'] ?? '') . (! $form['parent']->vars['valid'] ? ' callout alert' : null),
                                ],
                            ]); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class=" columns">
            <div class="news-add-form">
                <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                    <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                </button>

                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_department_index'); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
            </div>
        </div>
    </div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script>var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';</script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/department.js'); ?>"></script>
<?php $view['slots']->stop(); ?>