<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_category_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.ecommerce.category.delete', [], 'ecommerce')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>"  rel="stylesheet">
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_category_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.ecommerce.category.index', [], 'ecommerce'); ?></a></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_category_delete', ['id' => $category->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.ecommerce.category.delete', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('ecommerce.category.index.title', [], 'ecommerce'); ?> - <?php echo $view['translator']->trans('ecommerce.category.delete.title', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon'); ?>
<i class="icon-folder-open-2 color-menu-ecommerce"></i>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('ecommerce.category.delete.desc', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel'); ?><?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php // Funkcja wyświetlająca dzieci kategorii ?>
<?php function getChildrenView($cat, $view) { ?>
    <ul class="childrenView">
        <?php foreach ($cat as $children): ?>
            <li>
                <?php echo $children->getTitle().' - '.$children->getProducts()->count().' '.$view['translator']->trans('ecommerce.category.delete.details.product_count', [], 'ecommerce'); ?>
                <?php getChildrenView($children->getChildren(), $view); ?>
            </li>
        <?php endforeach; ?>
    </ul>
<?php } ?>
<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-doc-add"></i>
            <span><?php echo $view['translator']->trans('ecommerce.category.delete.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $view['translator']->trans('ecommerce.category.delete.confirm', [], 'ecommerce'); ?></strong></p>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($form['deleteCategory']); ?>
                    <?php echo $view['form']->widget($form['deleteCategory']); ?>
                </div>
                <span id="countNews"  wartosc="<?php echo $category->getProducts()->count() ?>"></span>
                <span id="countChildren"  wartosc="<?php echo $category->getChildren()->count() ?>"></span>
                <div class="confirmDelete" id="confirmDelete">
                    <?php if($category->getProducts()->count()!=0 || $category->getChildren()->count()!=0): ?>
                        <p><?php echo $view['translator']->trans('ecommerce.category.delete.details.list_children_count', [], 'ecommerce').' '.$category->getProducts()->count().' '.$view['translator']->trans('ecommerce.category.delete.details.product_count', [], 'ecommerce') ; ?></p>
                        <?php if($category->getChildren()->count() > 0): ?>
                            <p class="catDeleteQuestion"><?php echo $view['translator']->trans('ecommerce.category.delete.details.list_children', [], 'ecommerce') ?>:</p>
                            <?php getChildrenView($category->getChildren(), $view); ?>
                        <?php endif; ?>
                        <p class="catDeleteQuestion"><?php echo $view['translator']->trans('ecommerce.category.delete.details.confirm_children_products', [], 'ecommerce'); ?></p>
                        <div class="switch-admin">
                            <?php echo $view['form']->errors($form['deleteAll']); ?>
                            <?php echo $view['form']->widget($form['deleteAll']); ?>
                        </div>
                        <div class="confirmDeleteSubcategories" id="confirmDeleteSubcategories">
                            <p class="catDeleteQuestion"><?php echo $view['translator']->trans('ecommerce.category.delete.details.product_question', [], 'ecommerce'); ?></p>
                            <div class="radioDeleteCat">
                                <label>
                                    <?php echo $view['form']->widget($form['noDeleteNews'][0], ['required' => false]); ?>
                                    <span data-tooltip aria-haspopup="true" class="has-tip top" data-disable-hover="false" tabindex="1" title="<?php echo $view['translator']->trans('catDelete.unpinDesc'); ?>">
                                <?php echo $view['translator']->trans('catDelete.unpin'); ?>
                            </span>
                                </label>
                                <label>
                                    <?php echo $view['form']->widget($form['noDeleteNews'][1], ['required' => false]); ?>
                                    <span data-tooltip aria-haspopup="true" class="has-tip top" data-disable-hover="false" tabindex="1" title="<?php echo $view['translator']->trans('catDelete.changeCatDesc'); ?>">
                                <?php echo $view['translator']->trans('catDelete.changeCat'); ?>
                            </span>
                                </label>
                            </div>
                            <div class="selectCategories" id="selectCategories">
                                <p class="catDeleteQuestion"><?php echo $view['translator']->trans('ecommerce.category.delete.details.children_question', [], 'ecommerce'); ?></p>
                                <div class="newCategorySelect">
                                    <?php echo $view['form']->errors($form['newCategory']); ?>
                                    <?php echo $view['form']->widget($form['newCategory']); ?>
                                </div>
                            </div>
                        </div>
                        <?php echo $view['form']->widget($form); ?>
                    <?php else: ?>
                        <p><?php echo $view['translator']->trans('ecommerce.category.delete.details.list_children_count', [], 'ecommerce').' '.$category->getProducts()->count().' '.$view['translator']->trans('ecommerce.category.delete.details.product_count', [], 'ecommerce') ; ?></p>
                    <?php endif; ?>
                    <button type="submit" id="CatDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                        <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <?php echo $view['form']->widget($form); ?>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('admin_ecommerce_category_index'); ?>"><i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?></a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>

<?php echo $view->render('Components/modalTinyMCE.html.php'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
