<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_category_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.ecommerce.category.index', [], 'ecommerce')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>"  rel="stylesheet" type="text/css" />
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_category_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.ecommerce.category.index', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('ecommerce.category.index.title', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon'); ?>
<i class="icon-folder-open-2 color-menu-ecommerce"></i>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('ecommerce.category.index.desc', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel'); ?><?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php
/**
 * Render categories tree.
 *
 * @param array $categories
 * @param string $prefix
 * @param string $html
 * @return string
 */
$displayCategoriesTree = function ($categories, $prefix = '', $html = '') use (&$displayCategoriesTree, $view) {
    foreach ($categories as $key => $category) {
        $html .= $view->render($view['front']->getTemplateDir().'Ecommerce/Category/Components/row.html.php', [
            'category' => $category,
            'prefix' => $prefix,
            'hasPrev' => ! is_null($categories->get($key - 1)),
            'hasNext' => ! is_null($categories->get($key + 1)),
        ]);

        // Jeśli są podkategorie.
        if ($category->getChildren()->count()) {
            $html .= $displayCategoriesTree($category->getChildren(), $prefix . '<span class="cat-prefix">&nbsp;</span>');
        }
    }

    return $html;
};
?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <div class="pull-right box-tools">
            <?php if ($view['security']->isGranted('ROLE_ECOMMERCE_EDIT')): ?>
                <a href="<?php echo $view['router']->path('admin_ecommerce_category_new'); ?>" title="<?php echo $view['translator']->trans('catList.add'); ?>" class="button tiny primary buttonAddNew">
                    <i class="icon-folder-add"></i><?php echo $view['translator']->trans('catList.add'); ?>
                </a>
            <?php endif; ?>
        </div>
        <h3 class="box-title"><i class="icon-th-list-outline"></i>
            <span><?php echo $view['translator']->trans('ecommerce.category.index.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns tableResp">
                <table id="catList" class="catList row-border unstriped hover" style="width:100%">
                    <thead>
                    <tr>
                        <th><?php echo $view['translator']->trans('ecommerce.category.table.name', [], 'ecommerce'); ?></th>
                        <th></th>
                        <th><?php echo $view['translator']->trans('ecommerce.category.table.description', [], 'ecommerce'); ?></th>
                        <th><?php echo $view['translator']->trans('ecommerce.category.table.order_nr', [], 'ecommerce'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php echo $displayCategoriesTree($categories); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script>var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';</script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>" type="text/javascript"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
