<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_product_option_index'));
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Admin\WicmsBundle\Templating\Helper\ConfigHelper $configHelper */
$configHelper = $view['config'];

$view['slots']->set('title', $translator->trans('title.ecommerce.option.delete', [], 'ecommerce'));
$view['slots']->set('titleSite', $translator->trans('ecommerce.option.delete.title', [], 'ecommerce').' - '.$translator->trans('ecommerce.option.delete.title', [], 'ecommerce'));
$view['slots']->set('titleDesc', $translator->trans('ecommerce.option.delete.desc', [], 'ecommerce'));
$view['slots']->set('titleIcon', '<i class="icon-list-1 color-menu-ecommerce"></i>');
$view['slots']->set('helpRightPanel', '');
?>
<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css').$configHelper->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_product_option_index'); ?>"><?php echo $translator->trans('breadcrumbs.ecommerce.option.index', [], 'ecommerce'); ?></a></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_product_option_delete', ['id' => $option->getId()]); ?>"><?php echo $translator->trans('breadcrumbs.ecommerce.option.delete', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-doc-add"></i>
            <span><?php echo $translator->trans('ecommerce.option.delete.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $translator->trans('ecommerce.option.delete.confirm', [], 'ecommerce'); ?></strong></p>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($form['delete']); ?>
                    <?php echo $view['form']->widget($form['delete']); ?>
                </div>

                <button type="submit" id="AdminDeleteInput" class="button alert tiny" value="<?php echo $translator->trans('Form.delete'); ?>" disabled><i class="icon-cancel-circled"></i><?php echo $translator->trans('adminDelete.delete'); ?></button>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <?php echo $view['form']->widget($form); ?>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('admin_ecommerce_product_index'); ?>"><i class="icon-reply"></i> <?php echo $translator->trans('Form.backShow'); ?></a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
