<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_product_option_index'));
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Admin\WicmsBundle\Templating\Helper\ConfigHelper $configHelper */
$configHelper = $view['config'];

$view['slots']->set('title', $translator->trans('title.ecommerce.option.index', [], 'ecommerce'));
$view['slots']->set('titleSite', $translator->trans('ecommerce.option.index.title', [], 'ecommerce'));
$view['slots']->set('titleDesc', $translator->trans('ecommerce.option.index.desc', [], 'ecommerce'));
$view['slots']->set('titleIcon', '<i class="icon-list-1 color-menu-ecommerce"></i>');
$view['slots']->set('helpRightPanel', '');
?>
<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css').$configHelper->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_product_option_index'); ?>"><?php echo $translator->trans('breadcrumbs.ecommerce.option.index', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <div class="pull-right box-tools">
            <?php if ($view['security']->isGranted('ROLE_ECOMMERCE_EDIT')): ?>
                <a href="<?php echo $view['router']->path('admin_ecommerce_product_option_new'); ?>" title="<?php echo $translator->trans('ecommerce.option.add', [], 'ecommerce'); ?>" class="button tiny primary buttonAddNew">
                    <i class="icon-doc-add"></i><?php echo $translator->trans('ecommerce.option.add', [], 'ecommerce'); ?>
                </a>
            <?php endif; ?>
        </div>
        <h3 class="box-title"><i class="icon-newspaper-1"></i>
            <span><?php echo $translator->trans('ecommerce.option.index.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns tableResp">
                <table id="productList" class="display" style="width:100%">
                    <thead>
                    <tr>
                        <th><?php echo $translator->trans('ecommerce.option.table.id', [], 'ecommerce'); ?></th>
                        <th><?php echo $translator->trans('ecommerce.option.table.type', [], 'ecommerce'); ?></th>
                        <th><?php echo $translator->trans('ecommerce.option.table.label', [], 'ecommerce'); ?></th>
                        <th><?php echo $translator->trans('ecommerce.option.table.default_values', [], 'ecommerce'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php /** @var \Admin\EcommerceBundle\Entity\Option $option */
                    foreach ($options as $option): ?>
                        <tr>
                            <td><?php echo $option->getId(); ?></td>
                            <td><?php echo $option->getType(); ?></td>
                            <td>
                                <a href="<?php echo $view['router']->path('admin_ecommerce_product_show', ['id' => $option->getId()]); ?>"><b><?php echo $option->getLabel(); ?></b></a>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <?php if ($view['security']->isGranted('ROLE_ECOMMERCE_EDIT')): ?>
                                            <a href="<?php echo $view['router']->path('admin_ecommerce_product_option_edit', ['id' => $option->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $translator->trans('Table.editButton'); ?></a> |
                                            <a href="<?php echo $view['router']->path('admin_ecommerce_product_option_delete', ['id' => $option->getId()]); ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $translator->trans('Table.deleteButton'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <ul style="margin-bottom: 0;">
                                <?php foreach ($option->getDefaultValues() as $value): ?>
                                    <li><?php echo $value; ?></li>
                                <?php endforeach; ?>
                                </ul>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="medium-6 columns">
                <?php if ($view['security']->isGranted('ROLE_ECOMMERCE_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('admin_ecommerce_product_option_new'); ?>" title="<?php echo $translator->trans('ecommerce.option.add', [], 'ecommerce'); ?>" class="button primary newsListNew">
                        <i class="icon-doc-add"></i> <?php echo $translator->trans('ecommerce.option.add', [], 'ecommerce'); ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="medium-6 columns paginationBox">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                    'knp_pagination' => $options,
                ]); ?>
                <?php echo $view['knp_pagination']->render($options); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script>var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';</script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
