<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_product_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.ecommerce.product.edit', [], 'ecommerce')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.css'); ?>" rel="stylesheet">
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>"  rel="stylesheet">
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css'); ?>" rel="stylesheet">
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_product_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.ecommerce.product.index', [], 'ecommerce'); ?></a></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_product_edit', ['id' => $product->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.ecommerce.product.edit', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('ecommerce.product.index.title', [], 'ecommerce'); ?> - <?php echo $view['translator']->trans('ecommerce.product.edit.title', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon'); ?>
<i class="icon-shop color-menu-ecommerce"></i>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('ecommerce.product.edit.desc', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel'); ?><?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-doc-add"></i>
            <span><?php echo $view['translator']->trans('ecommerce.product.edit.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <?php if ($view['form']->errors($form)): ?>
            <div class="alert callout small"><?php echo $view['form']->errors($form); ?></div>
        <?php endif; ?>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.form.title.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('ecommerce.product.form.title.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['title']); ?></div>
                <?php echo $view['form']->widget($form['title'], [
                    'attr' => [
                        'class' => ($form['title']->vars['attr']['class'] ?? '') . (! $form['title']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.form.image.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('ecommerce.product.form.image.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="news-add-form">
                    <input type="hidden" name="crop_x" id="crop_x">
                    <input type="hidden" name="crop_y" id="crop_y">
                    <input type="hidden" name="crop_height" id="crop_height">
                    <input type="hidden" name="crop_width" id="crop_width">
                    <input type="hidden" name="cropSave" id="cropSave">

                    <div class="large reveal" id="windowModalEditCropper" data-reveal data-close-on-click="false">
                        <div class="containerCropper">
                            <img id="editCropperImage" data-save-url="<?php echo $view['router']->url('admin_ecommerce_product_save_ajax_image', ['id' => $product->getId()]); ?>" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg') ?>" alt="">
                        </div>
                        <div class="row buttonAddImage">
                            <div class="medium-12 columns">
                                <button type="button" class="button" id="save_photo" data-close aria-label="Close modal"><i class="icon-ok"></i> <?php echo $view['translator']->trans('ecommerce.category.form.image.save', [], 'ecommerce'); ?></button>
                                <button type="button" class="button secondary float-right"  data-close aria-label="Close modal"><i class="icon-cancel"></i> <?php echo $view['translator']->trans('Form.backShow'); ?></button>
                            </div>
                        </div>
                    </div>

                    <img id="editCropperPreview" class="previewImage thumbnail"  src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg') ?>" alt="">
                    <label class="AddImage" for="file_photo">
                        <input type="file" accept=".jpg,.jpeg,.png" name="file_photo" id="file_photo" class="InputFileHidden">
                        <span class="button" id="editImageDataFromParameter" type="button" cropper-width="<?php echo $view['config']->get('ecommerce_category.imageWidth'); ?>" cropper-height="<?php echo $view['config']->get('ecommerce_category.imageHeight'); ?>">
                            <i class="icon-upload"></i><?php echo $view['translator']->trans('ecommerce.category.form.addImage', [], 'ecommerce'); ?>
                        </span>
                    </label>
                </div>

                <div id="image-wrapper" data-image-url="<?php echo $view['assets']->getUrl('media/assets/Ecommerce/Products/thumbnailS/'); ?>">
                    <ul class="image-list">
                        <?php foreach ($product->getImages() as $image): ?>
                            <li data-id="<?php echo $image->getId(); ?>">
                                <img src="<?php echo $view['assets']->getUrl($image->getImageUrl('thumbnailS')); ?>" alt="">
                                <a href="<?php echo $view['router']->path('admin_ecommerce_product_delete_image', ['id' => $image->getId()]); ?>" class="remove-image">Usuń</a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.form.shortcut.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('ecommerce.product.form.shortcut.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['shortcut']); ?></div>
                <?php echo $view['form']->widget($form['shortcut'], [
                    'attr' => [
                        'class' => ($form['shortcut']->vars['attr']['class'] ?? '') . (! $form['shortcut']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.form.content.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('ecommerce.product.form.content.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['content']); ?></div>
                <?php echo $view['form']->widget($form['content'], [
                    'attr' => [
                        'class' => ($form['content']->vars['attr']['class'] ?? '') . (! $form['content']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.form.categories.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('ecommerce.product.form.categories.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['categories']); ?></div>
                <?php echo $view['form']->widget($form['categories'], [
                    'attr' => [
                        'class' => ($form['categories']->vars['attr']['class'] ?? '') . (! $form['categories']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.form.price.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('ecommerce.product.form.price.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['price']); ?></div>
                <?php echo $view['form']->widget($form['price'], [
                    'attr' => [
                        'class' => ($form['price']->vars['attr']['class'] ?? '') . (! $form['price']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.form.price_visible.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('ecommerce.product.form.price_visible.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['priceVisible']); ?></div>
                <?php echo $view['form']->widget($form['priceVisible'], [
                    'attr' => [
                        'class' => ($form['priceVisible']->vars['attr']['class'] ?? '') . (! $form['priceVisible']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.form.available.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('ecommerce.product.form.available.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['available']); ?></div>
                <?php echo $view['form']->widget($form['available'], [
                    'attr' => [
                        'class' => ($form['available']->vars['attr']['class'] ?? '') . (! $form['available']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.form.visible.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('ecommerce.product.form.visible.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['visible']); ?></div>
                <?php echo $view['form']->widget($form['visible'], [
                    'attr' => [
                        'class' => ($form['visible']->vars['attr']['class'] ?? '') . (! $form['visible']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $view['translator']->trans('ecommerce.product.form.options.title', [], 'ecommerce'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('ecommerce.product.form.options.desc', [], 'ecommerce'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <?php echo $view['form']->widget($form['enableOptions'], [
                    'attr' => [
                        'class' => ($form['enableOptions']->vars['attr']['class'] ?? '') . (! $form['enableOptions']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
                
                <div id="option-wrapper">
                    <p class="no-margin"><?php echo $view['translator']->trans('ecommerce.product.form.options.add', [], 'ecommerce'); ?></p>
                    <hr style="margin: 10px 0;">
                    <div class="input-group">
                        <select name="option" id="option-list" class="input-group-field">
                            <option value=""><?php echo $view['translator']->trans('ecommerce.product.form.options.placeholder', [], 'ecommerce'); ?></option>
                            <?php foreach ($options as $option): ?>
                                <option data-id="<?php echo $option->getId(); ?>" value="<?php echo $option->getId(); ?>" <?php echo (in_array($option->getId(), $product->getSelectedOptions()) || ($product->getOptions()->count() <= 0 && in_array($option, $product->getCategoriesOptions()))) ? 'style="display:none;"' : null; ?>><?php echo $option->getLabel(); ?></option>
                            <?php endforeach; ?>
                        </select>
                        <div class="input-group-button">
                            <button type="button" class="button" id="add-option"><?php echo $view['translator']->trans('Form.create'); ?></button>
                        </div>
                    </div>

                    <p class="no-margin"><?php echo $view['translator']->trans('ecommerce.product.form.options.selected', [], 'ecommerce'); ?></p>
                    <hr style="margin: 10px 0;">
                    <table id="product-option-list">
                        <thead>
                        <tr>
                            <th>Etykieta</th>
                            <th>Widoczny</th>
                            <th>Wartość</th>
                            <th>Usuń</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php if ($product->getOptions()->count() > 0): ?>
                                <?php foreach ($product->getOptions() as $option): ?>
                                    <?php echo $view->render($view['front']->getTemplateDir().'Ecommerce/Product/option_field.html.php', [
                                        'option' => $option->getOption(),
                                        'id' => $option->getId(),
                                        'value' => $option->getValue(),
                                        'visible' => $option->getVisible(),
                                    ]); ?>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <?php foreach ($product->getCategoriesOptions() as $option): ?>
                                    <?php echo $view->render($view['front']->getTemplateDir().'Ecommerce/Product/option_field.html.php', [
                                        'option' => $option,
                                        'visible' => 1,
                                    ]); ?>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="box metaTags collapsed-box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools"><span><i class="icon-up-open" data-widget="collapse"></i></span></div>
        <h3 class="box-title" data-widget="collapse">
            <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('metadata.block.header'); ?></span>
        </h3>
    </div>
    <div class="box-body " style="display: none;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('metadata.meta.title'); ?></strong><i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('metadata.meta.desc'); ?>"></i></p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="news-add-form">
                            <?php echo $view['form']->label($form['metaTitle']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['metaTitle']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['metaTitle']) ? $view['form']->widget($form['metaTitle'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaTitle'])); ?>
                        </div>
                        <div class="news-add-form">
                            <?php echo $view['form']->label($form['metaDescription']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['metaDescription']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['metaDescription']) ? $view['form']->widget($form['metaDescription'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaDescription'])); ?>
                        </div>
                        <div class="news-add-form">
                            <?php echo $view['form']->label($form['metaKeywords']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['metaKeywords']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['metaKeywords']) ? $view['form']->widget($form['metaKeywords'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaKeywords'])); ?>
                        </div>
                        <div class="news-add-form">
                            <?php echo $view['form']->label($form['metaCanonical']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['metaCanonical']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['metaCanonical']) ? $view['form']->widget($form['metaCanonical'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaCanonical'])); ?>
                        </div>
                        <div class="news-add-form">
                            <?php echo $view['form']->label($form['metaImage']) ?>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['metaImage']); ?>
                            </div>
                            <?php echo ($view['form']->errors($form['metaImage']) ? $view['form']->widget($form['metaImage'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['metaImage'])); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <?php echo $view['form']->widget($form); ?>
            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>"><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.send'); ?></button>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('admin_ecommerce_product_index'); ?>"><i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?></a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>

<?php echo $view->render('Components/modalTinyMCE.html.php'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/jquery-ui-1.12.1/jquery-ui.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.js'); ?>"></script>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js'); ?>'></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<script>
    $(function () {
        $('.image-list').sortable({
            placeholder: "image-list-item-placeholder",
            update: function (e, ui) {
                var sortedIDs = $('.image-list').sortable('toArray', { attribute: 'data-id' });
                $.ajax({
                    type: 'POST',
                    data: {
                        ids: sortedIDs,
                    },
                    dataType: 'json',
                    url: Routing.generate('admin_ecommerce_product_update_image_order', { id: <?php echo $product->getId(); ?> }),
                    success: function (response) {},
                });
            },
        }).disableSelection();

        $('#add-option').click(function (e) {
            var option_id = $('#option-list').val();

            if (option_id != null) {
                $.ajax({
                    url: Routing.generate('admin_ecommerce_product_option_field', { id: option_id }),
                    method: 'GET',
                    async: false,
                    success: function (response) {
                        $('#product-option-list').append($(response));
                        $('#option-list option:selected').hide();
                        $('#option-list').val('');
                    }
                });
            }
        });

        $('body').on('click', '.option-field-remove-row', function (e) {
            e.preventDefault();

            var $row = $(this).closest('.option-field-row');
            var option_id = $row.data('id');
            $row.remove();
            $('#option-list option[data-id="'+option_id+'"]').show();
        });

        $("#<?php echo $form['enableOptions']->vars['id']; ?>").change(function (e) {
            if ($(this).is(':checked')) {
                $('#option-wrapper').slideDown();
            } else {
                $('#option-wrapper').slideUp();
            }
        }).trigger('change');
    });
</script>
<?php $view['slots']->stop(); ?>
