<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('admin_ecommerce_product_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.ecommerce.product.index', [], 'ecommerce')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>" rel="stylesheet" type="text/css" />
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>"  rel="stylesheet" type="text/css" />
<link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.ecommerce'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_ecommerce_product_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.ecommerce.product.index', [], 'ecommerce'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('ecommerce.product.index.title', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon'); ?>
<i class="icon-shop color-menu-ecommerce"></i>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('ecommerce.product.index.desc', [], 'ecommerce'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel'); ?><?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <div class="pull-right box-tools">
            <?php if ($view['security']->isGranted('ROLE_ECOMMERCE_EDIT')): ?>
                <a href="<?php echo $view['router']->path('admin_ecommerce_product_new'); ?>" title="<?php echo $view['translator']->trans('ecommerce.product.add', [], 'ecommerce'); ?>" class="button tiny primary buttonAddNew">
                    <i class="icon-doc-add"></i><?php echo $view['translator']->trans('ecommerce.product.add', [], 'ecommerce'); ?>
                </a>
            <?php endif; ?>
        </div>
        <h3 class="box-title"><i class="icon-newspaper-1"></i>
            <span><?php echo $view['translator']->trans('ecommerce.product.index.subtitle', [], 'ecommerce'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns paginationBox paginationBoxCenter">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                    'knp_pagination' => $products,
                ]); ?>

                <?php echo $view['knp_pagination']->render($products); ?>
            </div>
            <div class="columns tableResp">
                <table id="productList" class="display" style="width:100%">
                    <thead>
                    <tr>
                        <th><?php echo $view['translator']->trans('ecommerce.product.table.id', [], 'ecommerce'); ?></th>
                        <th><?php echo $view['translator']->trans('ecommerce.product.table.image', [], 'ecommerce'); ?></th>
                        <th><?php echo $view['translator']->trans('ecommerce.product.table.title', [], 'ecommerce'); ?></th>
                        <th><?php echo $view['translator']->trans('ecommerce.product.table.shortcut', [], 'ecommerce'); ?></th>
                        <th><?php echo $view['translator']->trans('ecommerce.product.table.categories', [], 'ecommerce'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($products as $product): ?>
                        <tr>
                            <td><?php echo $product->getId(); ?></td>
                            <td>
                                <div class="imgThmbnail <?php echo ($product->getImage() ? 'nonebackground' : ''); ?>">
                                <?php if ($image = $product->getImage('thumbnail')): ?>
                                    <a href="<?php echo $view['router']->path('admin_ecommerce_product_show', ['id' => $product->getId()]); ?>">
                                        <img class="imgListBanner thumbnail" src="<?php echo $view['assets']->getUrl($image); ?>" alt="<?php echo $product->getTitle(); ?>" style="max-height: 50px;">
                                    </a>
                                <?php endif; ?>
                                </div>
                            </td>
                            <td>
                                <a href="<?php echo $view['router']->path('admin_ecommerce_product_show', ['id' => $product->getId()]); ?>"><b><?php echo $product->getTitle(); ?></b></a>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <a href="<?php echo $view['router']->path('admin_ecommerce_product_show', ['id' => $product->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a> |
                                        <?php if ($view['security']->isGranted('ROLE_ECOMMERCE_EDIT')): ?>
                                            <a href="<?php echo $view['router']->path('admin_ecommerce_product_edit', ['id' => $product->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a> |
                                            <a href="<?php echo $view['router']->path('admin_ecommerce_product_delete', ['id' => $product->getId()]); ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td><?php echo substr(trim(strip_tags($product->getShortcut())),0,200); ?> <?php echo (strlen(trim(strip_tags($product->getShortcut())))>200 ? "..." : ""); ?></td>
                            <td>
                                <?php foreach ($product->getCategories() as $category): ?>
                                    <span class="info label secondary showNewsButton"><?php echo $category->getTitle(); ?></span>
                                <?php endforeach; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="medium-6 columns">
                <?php if ($view['security']->isGranted('ROLE_ECOMMERCE_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('admin_ecommerce_product_new'); ?>" title="<?php echo $view['translator']->trans('ecommerce.product.add', [], 'ecommerce'); ?>" class="button primary newsListNew">
                        <i class="icon-doc-add"></i> <?php echo $view['translator']->trans('ecommerce.product.add', [], 'ecommerce'); ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="medium-6 columns paginationBox">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                    'knp_pagination' => $products,
                ]); ?>

                <?php echo $view['knp_pagination']->render($products); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script>var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';</script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/ecommerce.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
