<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_faq_question_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.category.catList')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/faq.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><?php echo $view['translator']->trans('main-menu.content'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.faq'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_faq_category_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.category.catList'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
    <?php echo $view['translator']->trans('faqQuestion.listTitle'); ?> - <?php echo $view['translator']->trans('catList.subTitle'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon'); ?>
    <i class="icon-help-circled-1 color-menu-content"></i>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleDesc'); ?>
    <?php echo $view['translator']->trans('catList.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel'); ?>

<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
     <?php
     /**
      * Render categories tree.
      *
      * @param $categories
      * @param string $html
      * @return string
      */
    $displayCategoryTree = function ($categories, $html = '') use (&$displayCategoryTree, $view) {
        foreach ($categories as $key => $category) {
            $html .= $view->render($view['front']->getTemplateDir().'FaqCategory/Components/row.html.php', [
                'category' => $category,
                'hasPrev' => ! is_null($categories->get($key - 1)),
                'hasNext' => ! is_null($categories->get($key + 1)),
            ]);
        }
        return $html;
    }
    ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('wi_admin_faq_category_new'); ?>" title="<?php echo $view['translator']->trans('catList.add'); ?>" class="button tiny primary buttonAddNew">
                        <i class="icon-folder-add"></i><?php echo $view['translator']->trans('catList.add'); ?>
                    </a>
                <?php endif; ?>
            </div>
            <h3 class="box-title"><i class="icon-th-list-outline"></i>
                <span><?php echo $view['translator']->trans('catList.listSubTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="columns tableResp">
                    <table id="catList" class="catList row-border unstriped hover" style="width:100%">
                        <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('catList.table.name'); ?></th>
                            <th></th>
                            <th><?php echo $view['translator']->trans('catList.table.description'); ?></th>
                            <th><?php echo $view['translator']->trans('catList.table.OrderNr'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php echo $displayCategoryTree($categories); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row navigationBottom">
                <div class="columns">
                    <a class="button secondary" href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('categoryForm.backListQuestion'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script>var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';</script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/faq.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
