<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_download_file_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.file.index')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/jquery.plupload.queue/css/jquery.plupload.queue.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/download.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><?php echo $view['translator']->trans('main-menu.modules_addons'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_download_file_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.list'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_download_file_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.new'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('file.list.title'); ?> - <?php echo $view['translator']->trans('file.new.subtitle'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-download-1 color-menu-modules-addons"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('file.new.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form, ['attr' => ['id' => 'file_form']]); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-download-1"></i><span><?php echo $view['translator']->trans('file.new.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('file.form.title.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('file.form.title.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="row">
                    <div class="medium-6 columns end">
                        <div class="formAlert"><?php echo $view['form']->errors($form['title']); ?></div>
                        <?php echo ($view['form']->errors($form['title']) ? $view['form']->widget($form['title'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['title'])); ?>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('file.form.content.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('file.form.content.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['content']); ?></div>
                <?php echo ($view['form']->errors($form['content']) ? $view['form']->widget($form['content'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['content'])); ?>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('file.form.categories.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('file.form.categories.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['categories']); ?></div>
                <?php echo ($view['form']->errors($form['categories']) ? $view['form']->widget($form['categories'], ['attr' => ['class' =>'callout alert']]) : $view['form']->widget($form['categories'])); ?>
            </div>
        </div>

        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('file.form.choose_file.title'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('file.form.choose_file.desc'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div id="uploader" class="file-new">Your browser doesn't have HTML5 support.</div>
                <?php if ($view['form']->errors($form['systemName'])): ?>
                    <div>Najpierw wybierz plik i kliknij wyślij. Po przesłaniu pliku kliknij zapisz.</div>
                <?php endif ?>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <button class="button" type="submit" id="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i> <?php echo $view['translator']->trans('Form.send'); ?>
            </button>

            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_download_file_index'); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
            </a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>
<?php echo $view->render('Components/modalTinyMCE.html.php'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/jquery.plupload.queue/jquery.plupload.queue.min.js') ?>"></script>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js'); ?>'></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/download.js'); ?>"></script>
<script>
$(function () {
    var max_file_count = 1;

    var uploader = $('#uploader').pluploadQueue({
        runtimes: 'html5,html4',
        url: Routing.generate('wi_admin_download_file_upload'),
        max_file_count: max_file_count,
        chunk_size: '200kb',
        max_retries: 3,
        dragdrop: true,
        multi_selection: false,

        init: {
            FilesAdded: function(up, files) {
                if (up.files.length > max_file_count) {
                    while (up.files.length> max_file_count) {
                        up.removeFile(up.files[max_file_count]);
                    }

                    alert('Max ' + max_file_count + ' files.');
                }
            },
            FileUploaded: function(up, file, info) {
                $('#wi_admin_downloadbundle_file_systemName').val(JSON.parse(info.response).filename);
                $('#wi_admin_downloadbundle_file_size').val(file.origSize);
            }
        }
    });

    $('#file_form').submit(function(e) {
        var up = uploader.pluploadQueue();

        if (up.files.length < 1) {
            alert('Wybierz plik');
            return false;
        }

        return true;
    });
});
</script>
<?php $view['slots']->stop(); ?>
