<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_download_file_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.file.index')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><?php echo $view['translator']->trans('main-menu.modules_addons'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_download_file_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.list'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_download_file_show', ['id' => $file->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.file.show'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('file.list.title'); ?> - <?php echo $view['translator']->trans('file.show.subtitle'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-download-1 color-menu-modules-addons"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('file.show.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-download-1"></i><span><?php echo $view['translator']->trans('file.show.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $view['translator']->trans('file.list.table.title'); ?>:</strong> <?php echo $file->getTitle(); ?></p>
                <p><strong><?php echo $view['translator']->trans('file.list.table.ext'); ?>:</strong> <?php echo $file->getExt(); ?></p>
                <p><strong><?php echo $view['translator']->trans('file.list.table.downloadCount'); ?>:</strong> <?php echo $file->getDownloadCount(); ?></p>
                <p>
                    <strong><?php echo $view['translator']->trans('file.list.table.categories'); ?>:</strong>
                    <?php foreach ($file->getCategories() as $category): ?>
                        <span class="label info secondary tiny category-label"><?php echo $category->getName(); ?></span>
                    <?php endforeach ?>
                </p>
                <p><strong><?php echo $view['translator']->trans('file.list.table.size'); ?>:</strong> <?php echo $view['front']->formatBytes($file->getSize()); ?></p>
                <p><strong><?php echo $view['translator']->trans('file.list.table.dateCreated'); ?>:</strong> <?php echo $file->getDateCreated()->format('H:i:s d.m.Y'); ?></p>
            </div>
            <div class="row">
                <div class="large-2 columns">
                <?php if ($view['security']->isGranted('ROLE_FILE_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('wi_admin_download_file_edit', ['id' => $file->getId()]); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                        <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                    </a>
                <?php endif; ?>
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form">
                        <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_download_file_index'); ?>">
                            <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/download.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
