<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_galleries_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.galleries.gallery.index')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/jquery-ui-1.12.1/jquery-ui.min.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/prettyPhoto/css/prettyPhoto.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/prettyPhoto/css/prettyPhoto.minimal.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/galleries.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.content'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_galleries_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.galleries.gallery.index'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('menuShowSite'); ?>
<?php
$showLink = $view['router']->path('wi_front_gallery_index');
if ($currentGallery) {
    $showLink = $view['router']->path('wi_front_gallery_album', ['id' => $currentGallery->getId(), 'slug' => $view['front']->slugify($currentGallery->getTitle())]);
}
?>
<div class="menu-show-site">
    <a class="button warning tiny" href="<?php echo $showLink; ?>" title="<?php echo $view['translator']->trans('top-bar.showArticle'); ?>" target="_blank">
        <i class="icon-monitor-1"></i><span><?php echo $view['translator']->trans('top-bar.showArticle'); ?></span>
    </a>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite') ?>
<?php echo $view['translator']->trans('galleries.gallery.index.title'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-camera-1 color-menu-content"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
<?php echo $view['translator']->trans('galleries.gallery.index.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>


<div class="album-navigation-wrapper">
    <span class="you-are-here"><?php echo $view['translator']->trans('galleries.navigation.you_are_here'); ?>:</span>
    <a href="<?php echo $view['router']->path('wi_admin_galleries_index'); ?>" class="folder"><?php echo $view['translator']->trans('galleries.navigation.main_folder'); ?>/</a><?php if ($currentGallery): ?><?php foreach ($currentGallery->getParentRecursive() as $parent): ?><a href="<?php echo $view['router']->path('wi_admin_galleries_index', ['id' => $parent->getId()]); ?>" class="folder"><?php echo $parent->getTitle(); ?>/</a><?php endforeach; ?><a href="<?php echo $view['router']->path('wi_admin_galleries_index', ['id' => $currentGallery->getId()]); ?>" class="folder"><?php echo $currentGallery->getTitle(); ?>/</a><?php endif; ?>
</div>

<p>
    <?php if ($currentGallery): ?>
        <?php if ($parentGallery = $currentGallery->getParent()): ?>
            <a href="<?php echo $view['router']->path('wi_admin_galleries_index', ['id' => $parentGallery->getId()]); ?>" class="button secondary tiny"><i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?></a>
        <?php else: ?>
            <a href="<?php echo $view['router']->path('wi_admin_galleries_index'); ?>" class="button secondary tiny"><i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?></a>
        <?php endif; ?>
        <?php if ($view['security']->isGranted('ROLE_GALLERY_EDIT')): ?>
            <a href="<?php echo $view['router']->path('wi_admin_galleries_photos_new', ['id' => $currentGallery->getId()]); ?>" class="button tiny"><i class="icon-upload"></i> <?php echo $view['translator']->trans('galleries.photo.new.title'); ?></a>
            <a href="#" class="button tiny" id="gallery-button"><i class="icon-upload"></i> <?php echo $view['translator']->trans('galleries.photo.many_upload_new'); ?></a>
        <?php endif ?>
    <?php endif ?>
    <?php if ($view['security']->isGranted('ROLE_GALLERY_EDIT')): ?>
        <button class="button tiny" data-open="modal-gallery-new"><i class="icon-plus"></i> <?php echo $view['translator']->trans('galleries.gallery.new.title'); ?></button>
    <?php endif ?>
    <span class="float-right">
        <span class="button tiny secondary gallery-view" data-view="grid"><i class="icon-th"></i></span>
        <span class="button tiny secondary gallery-view" data-view="list"><i class="icon-th-list"></i></span>
        <?php if ($currentGallery): ?>
            <a href="<?php echo $view['router']->path('wi_admin_galleries_edit', ['id' => $currentGallery->getId()]); ?>" title="<?php echo $view['translator']->trans('galleries.gallery.edit.title'); ?>" class="button tiny"><i class="icon-edit"></i> <?php echo $view['translator']->trans('galleries.gallery.edit.title'); ?></a>
        <?php endif ?>
    </span>
</p>

<div class="gallery-wrapper" <?php if ($currentGallery): ?>id="gallery-drop-area" data-id="<?php echo $currentGallery->getId(); ?>"<?php endif ?>>
    <div class="gallery-main-wrapper <?php if (! $currentGallery): ?>without-info<?php endif; ?>">
        <?php if ($galleries): ?>
            <h6><?php echo $view['translator']->trans('galleries.items.galleries'); ?></h6>
            <div class="items" id="galleries">
                <?php foreach ($galleries as $gallery): ?>
                    <?php $id = $gallery->getId(); ?>
                    <div class="item" data-id="<?php echo $id; ?>" data-url="<?php echo $view['router']->path('wi_admin_galleries_index', ['id' => $id]); ?>">
                        <div class="item-inner">
                            <div class="my-item-thumbnail">
                                <div class="my-item-thumbnail-inner">
                                    <?php if ($gallery->getCover()): ?>
                                        <img src="<?php echo $view['assets']->getUrl($gallery->getCoverUrl()); ?>">
                                    <?php else: ?>
                                        <i class="icon-folder"></i>
                                    <?php endif ?>
                                </div>
                            </div>
                            <div class="item-name">
                                <div class="item-name-inner">
                                    <div class="icon">
                                        <i class="icon-folder"></i>
                                    </div>
                                    <div class="name">
                                        <span title="<?php echo $gallery->getTitle(); ?>"><?php echo $gallery->getTitle(); ?></span>
                                    </div>
                                    <?php if ($view['security']->isGranted('ROLE_GALLERY_EDIT')): ?>
                                        <div class="item-menu">
                                            <span class="file-manager-dropdown-btn" data-toggle="dropdown-<?php echo $id; ?>">
                                                <i class="icon-ellipsis-vert"></i>
                                            </span>
                                            <div class="dropdown-pane item-dropdown" data-position="bottom" data-alignment="right" id="dropdown-<?php echo $id; ?>" data-dropdown data-close-on-click="true">
                                                <ul class="no-bullet">
                                                    <li><a href="<?php echo $view['router']->path('wi_admin_galleries_edit', ['id' => $id]); ?>" title="<?php echo $view['translator']->trans('galleries.gallery.edit.title'); ?>"><span><i class="icon-edit"></i> <?php echo $view['translator']->trans('galleries.gallery.edit.title'); ?></span></a></li>
                                                    <li><a href="<?php echo $view['router']->path('wi_admin_galleries_delete', ['id' => $id]); ?>" title="<?php echo $view['translator']->trans('galleries.gallery.delete.title'); ?>"><span><i class="icon-cancel-circled2"></i> <?php echo $view['translator']->trans('galleries.gallery.delete.title'); ?></span></a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endif ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach ?>
            </div>
        <?php endif ?>

        <?php if ($photos): ?>
            <h6><?php echo $view['translator']->trans('galleries.items.photos'); ?></h6>
            <div class="items" id="photos">
                <?php foreach ($photos as $photo): ?>
                    <?php $photoGallery = $photo->getGallery(); ?>
                    <?php $id = $photo->getId(); ?>
                    <div class="item" data-id="<?php echo $id; ?>">
                        <div class="item-inner">
                            <div class="my-item-thumbnail">
                                <div class="my-item-thumbnail-inner">
                                    <a href="<?php echo $view['assets']->getUrl($photo->getPhoto()); ?>" rel="prettyPhoto[1]"><img src="<?php echo $view['assets']->getUrl($photo->getPhoto('thumbnail')); ?>"></a>
                                </div>
                            </div>
                            <?php $dimensions = getimagesize(rtrim($view['config']->getParameter('web_dir'), '/').$view['assets']->getUrl($photo->getPhoto())); ?>
                            <div class="item-name"
                                 data-name="<?php echo $photo->getFilename(); ?>"
                                 data-img="<?php echo $view['front']->absoluteUrl($view['assets']->getUrl($photo->getPhoto())); ?>"
                                 data-thumbnail="<?php echo $view['assets']->getUrl($photo->getPhoto('thumbnail')); ?>"
                                 data-dimensions="<?php echo $dimensions[0].' x '.$dimensions[1].' px'; ?>"
                                 data-show-in-template="<?php echo $view['router']->path('wi_front_gallery_photo', ['id' => $id]); ?>"
                                 data-edit="<?php echo $view['router']->path('wi_admin_galleries_photos_edit', ['id' => $id]); ?>"
                                 data-size="<?php echo $view['front']->formatBytes(filesize(rtrim($view['config']->getParameter('web_dir'), '/').$view['assets']->getUrl($photo->getPhoto()))); ?>"
                            >
                                <div class="item-name-inner">
                                    <div class="icon">
                                        <i class="icon-picture"></i>
                                    </div>
                                    <div class="name">
                                        <span title="<?php echo $photo->getFilename(); ?>"><?php echo $photo->getFilename(); ?></span>
                                    </div>
                                    <?php if ($view['security']->isGranted('ROLE_GALLERY_EDIT')): ?>
                                        <div class="item-menu">
                                            <span class="file-manager-dropdown-btn" data-toggle="dropdown-<?php echo $id; ?>">
                                                <i class="icon-ellipsis-vert"></i>
                                            </span>
                                            <div class="dropdown-pane item-dropdown" data-position="bottom" data-alignment="right" id="dropdown-<?php echo $id; ?>" data-dropdown data-close-on-click="true">
                                                <ul class="no-bullet">
                                                    <li><a href="<?php echo $view['router']->path('wi_front_gallery_photo', ['id' => $id]); ?>" title="<?php echo $view['translator']->trans('galleries.photo.show_in_template'); ?>" target="_blank"><span><i class="icon-monitor-1"></i> <?php echo $view['translator']->trans('galleries.photo.show_in_template'); ?></span></a></li>
                                                    <li><a href="<?php echo $view['assets']->getUrl($photo->getPhoto()); ?>" title="<?php echo $view['translator']->trans('galleries.photo.show_file'); ?>" target="_blank"><span><i class="icon-eye"></i> <?php echo $view['translator']->trans('galleries.photo.show_file'); ?></span></a></li>
                                                    <li><a href="<?php echo $view['assets']->getUrl($photo->getPhoto()); ?>" title="<?php echo $view['translator']->trans('galleries.photo.download'); ?>" download><span><i class="icon-download"></i> <?php echo $view['translator']->trans('galleries.photo.download'); ?></span></a></li>
                                                    <li><a href="<?php echo $view['router']->path('wi_admin_galleries_photos_edit', ['id' => $id]); ?>" title="<?php echo $view['translator']->trans('galleries.photo.edit_photo'); ?>"><span><i class="icon-edit"></i> <?php echo $view['translator']->trans('galleries.photo.edit_photo'); ?></span></a></li>
                                                    <li><a href="<?php echo $view['router']->path('wi_admin_galleries_photos_delete', ['id' => $id]); ?>" title="<?php echo $view['translator']->trans('galleries.photo.delete_photo'); ?>" class="confirm" data-name="<?php echo $photo->getFilename(); ?>"><span><i class="icon-cancel-circled2"></i> <?php echo $view['translator']->trans('galleries.photo.delete_photo'); ?></span></a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endif ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach ?>
            </div>
        <?php endif ?>
    </div>
    <?php if ($currentGallery): ?>
        <div class="gallery-info-wrapper" id="gallery-info-wrapper"
             data-name="<?php echo $currentGallery->getTitle(); ?>"
             data-icon="icon-folder"
        >
            <div class="gallery-info-inner-wrapper">
                <div class="gallery-info-header">
                    <div class="name"><?php echo $currentGallery->getTitle(); ?></div>
                </div>
                <div class="gallery-info-stats" id="gallery-stats">
                    <span class="gallery-stat" data-tooltip title="<?php echo $view['translator']->trans('galleries.details.albums_count'); ?>"><i class="icon-folder"></i> <?php echo $currentGallery->getChildren()->count(); ?></span>
                    <span class="gallery-stat" data-tooltip title="<?php echo $view['translator']->trans('galleries.details.photos_count'); ?>"><i class="icon-picture"></i> <?php echo $currentGallery->getPhotos()->count(); ?></span>
                </div>
                <div class="gallery-info-tab-content" id="gallery-info-tab-content">
                    <div class="img">
                        <?php if ($cover = $currentGallery->getCoverUrl()): ?>
                            <img src="<?php echo $view['assets']->getUrl($cover); ?>">
                        <?php else: ?>
                            <div class="icon">
                                <i class="icon-folder"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if ($currentGallery->getShortContent()): ?>
                        <div class="description">
                            <section><?php echo $currentGallery->getShortContent(); ?></section>
                        </div>
                    <?php endif; ?>
                    <div class="details">
                        <div class="input-group clipboard">
                            <span class="infoCopyUrl" style="opacity: 0; z-index: -1;"><span><?php echo $view['translator']->trans('galleries.details.copied'); ?></span></span>
                            <input type="text" id="gallery_url" class="input-group-field gallery_url" readonly value="<?php echo $view['router']->url('wi_front_gallery_album', ['id' => $currentGallery->getId(), 'slug' => $view['front']->slugify($currentGallery->getTitle())]) ?>">
                            <div class="input-group-button">
                                <button type="button" id="copy-to-clipboard" class="copy-to-clipboard button" data-tooltip title="<?php echo $view['translator']->trans('galleries.details.copy_to_clipboard'); ?>"><i class="icon-clipboard-2"></i></button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="gallery-info-tab-content" id="picture-info-tab-content" style="display: none;">
                    <div class="img">
                        <img src="">
                    </div>
                    <div class="details">
                        <p>Rozmiar: <strong id="picture-size"></strong></p>
                        <p>Wymiary: <strong id="picture-dimensions"></strong></p>
                        <div class="input-group clipboard gallery-picture-clipboard">
                            <span class="infoCopyUrl" style="opacity: 0; z-index: -1;"><span><?php echo $view['translator']->trans('galleries.details.copied'); ?></span></span>
                            <input type="text" id="photo_url" class="input-group-field gallery_url" readonly>
                            <div class="input-group-button">
                                <button type="button" id="copy-to-clipboard-2" class="copy-to-clipboard button" data-tooltip title="<?php echo $view['translator']->trans('galleries.details.copy_to_clipboard'); ?>"><i class="icon-clipboard-2"></i></button>
                            </div>
                        </div>
                        <div class="gallery-picture-links">
                            <a href="" target="_blank" id="show-in-template" class="button tiny"><?php echo $view['translator']->trans('galleries.photo.show_in_template'); ?></a>
                            <a href="" id="picture-edit" class="button secondary tiny"><?php echo $view['translator']->trans('galleries.photo.edit_photo'); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif ?>
</div>

<?php if ($view['security']->isGranted('ROLE_GALLERY_EDIT')): ?>
    <!-- Modals -->
    <div class="reveal tiny" id="modal-gallery-new" data-reveal>
        <div class="row">
            <div class="columns">
                <h3><?php echo $view['translator']->trans('galleries.gallery.form.album_name'); ?></h3>
                <?php echo $view['form']->start($form); ?>
                    <div class="formAlert"><?php echo $view['form']->errors($form['title']); ?></div>
                    <?php echo $view['form']->widget($form['title'], [
                        'attr' => [
                            'class' => ($form['title']->vars['attr']['class'] ?? '') . (! $form['title']->vars['valid'] ? ' callout alert' : null),
                        ],
                    ]); ?>

                    <div class="float-right">
                        <button type="button" class="button no-margin tiny clear" data-close><?php echo $view['translator']->trans('galleries.gallery.form.cancel'); ?></button>
                        <button type="submit" class="button no-margin tiny"><?php echo $view['translator']->trans('galleries.gallery.form.create'); ?></button>
                    </div>
                <?php echo $view['form']->end($form); ?>
            </div>
        </div>

        <button class="close-button" data-close aria-label="Close modal" type="button">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>

    <div class="tiny reveal upload-progress-wrapper" id="upload-progress-wrapper" data-reveal data-close-on-click="false" data-close-on-esc="false">
        <div class="upload-loader-wrapper">
            <div class="lds-roller"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
        </div>
        <h3><?php echo $view['translator']->trans('galleries.photo.upload.upload_photos'); ?> <span id="current-number"></span> <?php echo $view['translator']->trans('galleries.photo.upload.of'); ?> <span id="total-number"></span></h3>
        <div class="upload-progress">
            <div id="upload-progress" class="progress" role="progressbar" tabindex="0" aria-valuemin="0" aria-valuemax="100">
                <span class="progress-meter" style="width: 0%">
                    <p class="progress-meter-text">0%</p>
                </span>
            </div>
        </div>
        <div class="callout primary"><?php echo $view['translator']->trans('galleries.photo.upload.info'); ?></div>
    </div>
<?php endif ?>

<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/jquery-ui-1.12.1/jquery-ui.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/prettyPhoto/js/jquery.prettyPhoto.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/galleries.js'); ?>"></script>
<script>
$(function () {
    <?php if (! $newAlbumValid): ?>
        $('#modal-gallery-new').foundation('open');
    <?php endif ?>

    var $confirm = $('.confirm');

    if ($confirm.length > 0) {
        $confirm.click(function (e) {
            return confirm("<?php echo $view['translator']->trans('Form.confirm_delete_question'); ?> " + $(this).data('name'));
        });
    }

    $('#galleries').sortable({
        placeholder: 'item-placeholder',
        update: function (e, ui) {
            var ids = $('#galleries').sortable('toArray', { attribute: 'data-id' });

            $.ajax({
                type: 'POST',
                data: {
                    ids: ids,
                },
                dataType: 'JSON',
                url: Routing.generate('wi_admin_galleries_update_order', { id: '<?php echo ($currentGallery ? $currentGallery->getId() : null); ?>' }),
                success: function (response) {
                    console.log(response);
                }
            });
        }
    });

    <?php if ($currentGallery): ?>
        $('#photos').sortable({
            placeholder: 'item-placeholder',

            update: function (e, ui) {
                var ids = $('#photos').sortable('toArray', { attribute: 'data-id' });

                $.ajax({
                    type: 'POST',
                    data: {
                        ids: ids,
                    },
                    dataType: 'JSON',
                    url: Routing.generate('wi_admin_galleries_update_photo_order', { id: '<?php echo $currentGallery->getId(); ?>' }),
                    success: function (response) {
                        console.log(response);
                    }
                });
            }
        });
    <?php endif; ?>

    $('#photos .item .item-name').click(function (e) {
        var $wrapper = $('#gallery-info-wrapper');
        $('#gallery-info-tab-content').hide();
        $('#gallery-stats').hide();
        $wrapper.find('.gallery-info-header .icon i').attr('class', 'icon-picture');
        $wrapper.find('.gallery-info-header .name').text($(this).data('name'));
        $('#picture-info-tab-content').find('img').attr('src', $(this).data('thumbnail'));
        $('#picture-info-tab-content').find('#photo_url').val($(this).data('img'));
        $('#picture-info-tab-content').find('#picture-size').text($(this).data('size'));
        $('#picture-info-tab-content').find('#picture-dimensions').text($(this).data('dimensions'));
        $('#picture-info-tab-content').find('#show-in-template').attr('href', $(this).data('show-in-template'));
        $('#picture-info-tab-content').find('#picture-edit').attr('href', $(this).data('edit'));
        $('#picture-info-tab-content').show();
    });
});
</script>
<?php $view['slots']->stop(); ?>
