<?php $view->extend('::wicms.html.php') ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_contact_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.contact.messages')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/contact.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li><?php echo $view['translator']->trans('main-menu.micro_web_crm'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_contact_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.contact.index'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_contact_messages_all'); ?>"><?php echo $view['translator']->trans('breadcrumbs.contact.messages'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('contact.title'); ?> - <?php echo $view['translator']->trans('contact.messages'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-post color-menu-micro-web-crm"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('contact.descMessages'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/contact.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>

<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title"><i class="icon-mail"></i>
            <span><?php echo $view['translator']->trans('contactMessages.title'); ?></span>
        </h3>
        <small><?php echo $view['translator']->trans('contactMessages.selectInfo'); ?></small>
        <div class="formSelectHeader <?php echo $forms ? 'activeMoreButton" data-toggle="moreForm' : '' ?>">
            <h6><?php echo ! is_null($form) ? $form->getName() : $view['translator']->trans('contactLeads.allForm'); ?></h6>
        </div>
        <div class="dropdown-pane moreForm" data-position="bottom" data-alignment="left" id="moreForm" data-dropdown data-auto-focus="false" data-close-on-click="true">
            <a href="<?php echo $view['router']->path('wi_admin_contact_messages_all'); ?>" class="<?php echo ( is_null($form) ? 'active' : ''); ?>">
                <?php echo $view['translator']->trans('contactLeads.allForm'); ?>
            </a><br>
            <?php foreach ($forms as $formItem): ?>
                <a href="<?php echo $view['router']->path('wi_admin_contact_messages', ['id' => $formItem->getId()]); ?>" class="<?php echo (! is_null($form) && $form->getId() == $formItem->getId()) ? 'active' : ''; ?>"><?php echo $formItem->getName(); ?></a><br>
            <?php endforeach ?>
        </div>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns tableResp">
                <table id="messagesList">
                    <thead>
                    <tr>
                        <th><?php echo $view['translator']->trans('contactMessages.table.id'); ?></th>
                        <th><?php echo $view['translator']->trans('contactMessages.table.status'); ?></th>
                        <th><?php echo $view['translator']->trans('contactMessages.table.sender'); ?></th>
                        <th><?php echo $view['translator']->trans('contactMessages.table.message'); ?></th>
                        <th><?php echo $view['translator']->trans('contactMessages.table.date'); ?></th>
                        <th><?php echo $view['translator']->trans('contactMessages.table.source'); ?></th>
                    </tr>
                    </thead>
                    <tobdy>
                        <?php foreach ($answers as $answer): ?>
                            <tr>
                                <td data-open="answerModal<?php echo $answer->getId(); ?>">
                                    <?php echo $answer->getId(); ?>
                                </td>
                                <td>
                                    <?php echo $view->render(
                                        $view['front']->getTemplateDir().'Inbox/Components/formStatus.html.php',
                                        array('prefix' => 'table', 'statuses' => $statusesTable, 'answerId' => $answer->getId(), 'statusId' => $answer->getStatus()->getId(), 'labelNameActiv' => $answer->getStatus()->getGroup())); ?>
                                </td>
                                <td data-open="answerModal<?php echo $answer->getId(); ?>">
                                    <?php foreach ($answer->getIdentityFields() as $field): ?>
                                        <p>
                                            <strong><?php echo $field->getField()->getName(); ?>:</strong>
                                            <span><?php echo $field->getFieldValue(); ?> <?php echo $field->getFieldTextValue(); ?> <?php echo $field->getFieldFileValue(); ?></span>
                                        </p>
                                    <?php endforeach; ?>
                                    <?php if ($view['security']->isGranted('ROLE_CONTACT_EDIT')): ?>
                                        <div class="buttonItemsBox">
                                            <div class="buttonsItems">
                                                <a data-open="answerModal<?php echo $answer->getId(); ?>"><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td data-open="answerModal<?php echo $answer->getId(); ?>">
                                    <?php foreach ($answer->getMessagesFields() as $field): ?>
                                        <p>
                                            <strong><?php echo $field->getField()->getName(); ?>:</strong>
                                        </p>
                                        <p>
                                            <span><?php echo $field->getFieldValue(); ?> <?php echo $field->getFieldTextValue(); ?> <?php echo $field->getFieldFileValue(); ?></span>
                                        </p>
                                    <?php endforeach; ?>
                                </td>
                                <td data-open="answerModal<?php echo $answer->getId(); ?>">
                                    <?php echo $answer->getDateCreated()->format('Y-m-d H:i:s'); ?>
                                </td>
                                <td data-open="answerModal<?php echo $answer->getId(); ?>">
                                    <?php echo $answer->getForm()->getName(); ?>
                                </td>
                            </tr>
                            <div class="reveal answerModal" id="answerModal<?php echo $answer->getId(); ?>" data-reveal>
                                <div class="row infoGeneral">
                                    <div class="columns small-3 medium-1 large-1">
                                        <h4>
                                            <?php echo $answer->getId(); ?>
                                        </h4>
                                    </div>
                                    <div class="columns small-9 medium-6 large-6">
                                        <p>
                                            <strong><i class="icon-download"></i></strong>
                                            <span>
                                            <?php echo $answer->getForm()->getName(); ?>
                                        </span>
                                        </p>
                                        <p>
                                            <strong><i class="icon-calendar"></i></strong>
                                            <span>
                                            <?php echo $answer->getDateCreated()->format('Y-m-d H:i:s'); ?>
                                        </span>
                                        </p>
                                    </div>
                                    <div class="columns small-9 medium-5 large-5">
                                        <?php echo $view->render(
                                            $view['front']->getTemplateDir().'Inbox/Components/formStatus.html.php',
                                            array('prefix' => 'modal', 'statuses' => $statusesTable, 'answerId' => $answer->getId(), 'statusId' => $answer->getStatus()->getId(), 'labelNameActiv' => $answer->getStatus()->getGroup())); ?>
                                    </div>
                                </div>
                                <div class="row infoAnswer">
                                    <div class="columns">
                                        <form action="">
                                            <?php foreach ($answer->getFields() as $field): ?>
                                                <?php $type = $field->getField()->getFormFieldType()->getType(); ?>
                                                <?php $label = $field->getField()->getLabel(); ?>
                                                <?php $place = $field->getField()->getPlaceholder(); ?>
                                                <?php $name = $field->getField()->getName(); ?>

                                                <?php if ($type == 'textarea'): ?>
                                                    <label for="field<?php echo $answer->getId(); ?>-<?php echo $field->getId(); ?>">
                                                        <?php echo $label; ?>
                                                        <button class="editAnswerField" type="button" data-input="field<?php echo $answer->getId(); ?>-<?php echo $field->getId(); ?>" data-button="fieldEdit<?php echo $answer->getId(); ?>">
                                                            <i class="icon-pencil"></i>
                                                        </button>
                                                    </label>
                                                    <textarea rows="4" cols="50" readonly placeholder="<?php echo $place; ?>" id="field<?php echo $answer->getId(); ?>-<?php echo $field->getId(); ?>"><?php echo $field->getFieldTextValue(); ?></textarea>
                                                <?php else: ?>
                                                    <label for="field<?php echo $answer->getId(); ?>-<?php echo $field->getId(); ?>">
                                                        <?php echo $label; ?>
                                                        <button class="editAnswerField" type="button" data-input="field<?php echo $answer->getId(); ?>-<?php echo $field->getId(); ?>" data-button="fieldEdit<?php echo $answer->getId(); ?>">
                                                            <i class="icon-pencil"></i>
                                                        </button>
                                                    </label>
                                                    <input id="field<?php echo $answer->getId(); ?>-<?php echo $field->getId(); ?>" type="<?php echo $type; ?>" value="<?php echo $field->getFieldValue(); ?>" placeholder="<?php echo $place; ?>" readonly />
                                                <?php endif; ?>
                                            <?php endforeach; ?>
                                            <button class="button hide tiny float-right" id="fieldEdit<?php echo $answer->getId(); ?>" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                                                <i class="icon-edit"></i>
                                                <?php echo $view['translator']->trans('Form.send'); ?>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                                <hr>
                                <div class="row">
                                    <div class="columns">
                                        <h3><?php echo $view['translator']->trans('contactLeads.modal.notes'); ?></h3>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="columns">
                                        <form >
                                            <label for="newNote<?php echo $answer->getId(); ?>"></label>
                                            <textarea name="note" rows="4" cols="50" placeholder="<?php echo $view['translator']->trans('contactLeads.modal.newNotes'); ?>" id="newNote<?php echo $answer->getId(); ?>" data-idanswer="<?php echo $answer->getId(); ?>"></textarea>
                                            <button class="button tiny float-right newNoteForm"  type="button" data-idanswer="<?php echo $answer->getId(); ?>">
                                                <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
                                            </button>
                                        </form>

                                    </div>
                                </div>
                                <div class="answerNote" data-idanswer="<?php echo $answer->getId(); ?>">
                                <?php foreach ($answer->getNotes() as $note):  ?>
                                    <div class="row">
                                        <div class="columns small-12 medium-2">
                                            <span><?php echo $note->getDateCreated()->format('Y-m-d H:i:s'); ?></span>
                                        </div>
                                        <div class="columns small-12 medium-10">
                                            <p>
                                                <?php echo $note->getNote(); ?>
                                            </p>
                                        </div>
                                    </div>
                                    <hr>
                                <?php endforeach; ?>
                                </div>
                                <button class="close-button" data-close aria-label="Close modal" type="button">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endforeach; ?>
                    </tobdy>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="columns">
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_contact_index'); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop() ?>
