<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_block_itemHTML_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.item.Delete')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/block.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li><?php echo $view['translator']->trans('main-menu.template_extension'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.item'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_delete', ['id' => $itemHTML->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.Delete'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('item.listTitle'); ?> - <?php echo $view['translator']->trans('itemDelete.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-th-large-2"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('itemDelete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<div class="box collapsed-box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title">
            <i class="icon-doc-remove"></i>
            <span><?php echo $view['translator']->trans('itemDelete.listSubTitle'); ?> - <?php echo $itemHTML->getName(); ?></span>
        </h3></div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $view['translator']->trans('itemDelete.dataNews'); ?></strong></p>

                <?php echo $view['form']->start($deleteForm); ?>
                <?php echo $view['form']->errors($deleteForm); ?>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($deleteForm['deleteItemHTML']); ?>
                    <?php echo $view['form']->widget($deleteForm['deleteItemHTML']); ?>
                </div>
                <p><?php echo $view['translator']->trans('itemDelete.dataNewsSub'); ?>:<br>
                    <strong><?php echo $view['translator']->trans('itemForm.name'); ?></strong> <?php echo $itemHTML->getName() ?><br>
                </p>
                <button type="submit" id="ItemHTMLDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                    <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                </button>
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_block_itemHTML_show', array('id' => $itemHTML->getId())); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
                <?php echo $view['form']->end($deleteForm); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/block.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
