<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_block_itemHTML_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.item.List')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>" >
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/block.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><?php echo $view['translator']->trans('main-menu.template_extension'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.item.item'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
    <?php echo $view['translator']->trans('block.listTitle'); ?> - <?php echo $view['translator']->trans('itemList.subTitle'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon'); ?>
    <i class="icon-th-large-2"></i>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleDesc'); ?>
    <?php echo $view['translator']->trans('itemList.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
    <div class="box manageBlocks">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="configCategory-dropdown">
                 <i class="icon-ellipsis-vert"></i>
            </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configCategory-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_block_new'); ?>"  title="<?php echo $view['translator']->trans('blockList.addNewBlock'); ?>">
                                    <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('blockList.addNewBlock'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo $view['router']->path('wi_admin_block_index'); ?>" title="<?php echo $view['translator']->trans('blockList.manageBlock'); ?>">
                                <span><i class="icon-folder-2"></i> <?php echo $view['translator']->trans('blockList.manageBlock'); ?></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title"><i class="icon-cog-5"></i>
                <span><?php echo $view['translator']->trans('blockList.manageBar'); ?></span>
            </h3>
        </div>
    </div>
    <?php foreach($blocks as $key => $block): ?>
    <div class="boxPagesGroup box collapsed-box">
       <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_new', ['block_id' => $block->getId()]); ?>" title="<?php echo $view['translator']->trans('itemList.addNewItem'); ?>" class="button tiny primary buttonAddNew">
                        <i class="icon-folder-add"></i>
                        <?php echo $view['translator']->trans('itemList.addNewItem'); ?>
                    </a>
                <?php endif; ?>
                <span class="box-btn" data-toggle="configPagesGroup<?php echo $block->getId()?>-dropdown">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="left" id="configPagesGroup<?php echo $block->getId()?>-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_new', ['block_id' => $block->getId()]); ?>" title="<?php echo $view['translator']->trans('itemList.addNewItem'); ?>">
                                    <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('itemList.addNewItem'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT') & $block->getType()=='U'): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_block_delete', ['id' => $block->getId()]); ?>" class="">
                                    <span><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('blockDelete.Delete2'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <li class="odciecie">
                            <button class="collapseAll" type="button">
                                <span><i class="icon-collapse"></i><?php echo $view['translator']->trans('pagesList.collapse')?></span>
                            </button>
                        </li>
                        <li class="odciecie">
                            <button class="expandAll" type="button">
                                <span><i class="icon-expand"></i><?php echo $view['translator']->trans('pagesList.expand')?></span>
                            </button>
                        </li>
                    </ul>
                </div>
                <span>
                    <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-th-large-2"></i>
                <span><?php echo $block->getName(); ?> (<?php echo $block->getItems()->count(); ?>)</span>
            </h3>
                <input type="text" class="searchThisGroup" data-table="pagesGroupTable<?php echo $key ?>" placeholder="<?php echo $view['translator']->trans('itemList.searchBox')?>">
            <?php if(! is_null($view['request']->getParameter('q'))): ?>
                <a class="clearFilter" href="<?php echo $view['router']->path('wi_admin_block_itemHTML_index'); ?>" title="<?php echo $view['translator']->trans('newsList.clearFilter'); ?>"><i class="icon-cancel"></i></a>
            <?php endif; ?>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none">
            <br>
            <div class="row">
                <div class="columns tableResp">
                    <table id="itemHTMLGroupTable" class="itemHTMLTable">
                        <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('itemForm.name'); ?></th>
                            <th><?php echo $view['translator']->trans('itemForm.content'); ?></th>
                            <th><?php echo $view['translator']->trans('itemForm.orderNr'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php foreach($block->getItems() as $key => $item): ?>
                            <tr>
                                <td><a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_show', ['id' => $item->getId()]); ?>"><b><?php echo $item->getName(); ?></b></a>
                                    <div class="buttonItemsBox">
                                        <div class="buttonsItems">
                                            <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_show', ['id' => $item->getId()]); ?>" class=""><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a>
                                            <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')) { ?>
                                                <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_edit', ['id' => $item->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a>
                                            <?php } ?>
                                            <?php if ($view['security']->isGranted('ROLE_BLOCKS_EDIT')) { ?>
                                                <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_delete', ['id' => $item->getId()]); ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="callout itemHtml">
                                        <?php echo $item->getContent(); ?>
                                        <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_show', ['id' => $item->getId()]); ?>" class="tiny button secondary radius float-right itemMoreButton" title="ItemHTMLMore"><?php echo $view['translator']->trans('more'); ?>...</a>

                                    </div>
                                </td>
                                <td>
                                    <div class="OrderNrForm">
                                    <?php if (! is_null($block->getItems()->get($key - 1))): ?>
                                        <div><a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_update_order', ['id' => $item->getId(), 'sort_dir' => 'up']); ?>" class="button secondary tiny"><i class="icon-up-big margin-center"></i></a></div>
                                    <?php else: ?>
                                        <div><span class="button disabled secondary tiny"><i class="icon-up-big margin-center"></i></span></div>
                                    <?php endif ?>
                                    <?php if (! is_null($block->getItems()->get($key + 1))): ?>
                                        <div><a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_update_order', ['id' => $item->getId(), 'sort_dir' => 'down']); ?>" class="button secondary tiny"><i class="icon-down-big margin-center"></i></a></div>
                                    <?php else: ?>
                                        <div><span class="button disabled secondary tiny"><i class="icon-down-big margin-center"></i></span></div>
                                    <?php endif ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                   </table>
                </div>
            </div>
            <?php if($view['security']->isGranted('ROLE_BLOCKS_EDIT')): ?>
                <div class="row columns addNewPage">
                    <a href="<?php echo $view['router']->path('wi_admin_block_itemHTML_new', ['block_id' => $block->getId()]); ?>" class="button" title="<?php $view['translator']->trans('itemList.addInGr')?>"><?php echo $view['translator']->trans('itemList.add'); ?></a>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php $i=1; endforeach; ?>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js'); ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/block.js'); ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>
