<?php $view->extend('::wicms.html.php'); ?>

<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_link_index')); ?>
<?php $view['slots']->set('title', $view['translator']->trans('link.meta.title', [], 'link')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/link.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><?php echo $view['translator']->trans('main-menu.modules_addons'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_link_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.link', [], 'link'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('link.title', [], 'link'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-link color-menu-modules-addons"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-link"></i> <span><?php echo $view['translator']->trans('link.url.shortener', [], 'link'); ?></span>
            </h3>
        </div>
        <div class="box-body " style="display: block;">
            <?php echo $view['form']->start($form); ?>
            <div class="short-link-wrapper">
                <h2><?php echo $view['translator']->trans('link.form.simplify_link', [], 'link'); ?></h2>
                <div class="short-link-form">
                    <div class="input-group">
                        <?php echo $view['form']->widget($form['url']); ?>
                        <div class="input-group-button">
                            <button class="button" type="submit"><?php echo $view['translator']->trans('link.form.shorten', [], 'link'); ?></button>
                        </div>

                    </div>

                    <div class="enable-utm">
                        <div class="enable-utm-switch switch small">
                            <?php echo $view['form']->errors($form['utmEnable']); ?>
                            <?php echo $view['form']->widget($form['utmEnable']); ?>
                        </div>
                        <div class="enable-utm-info"><?php echo $view['translator']->trans('link.form.utmEnable', [], 'link'); ?></div>
                    </div>

                    <div class="short-link-utm" id="short-link-utm">
                        <div class="row">
                            <div class="large-4 columns">
                                <?php echo $view['form']->label($form['utmSource']); ?>
                                <div class="input-group">
                                    <?php echo $view['form']->widget($form['utmSource']); ?>
                                </div>
                            </div>
                            <div class="large-4 columns">
                                <?php echo $view['form']->label($form['utmMedium']); ?>
                                <div class="input-group">
                                    <?php echo $view['form']->widget($form['utmMedium']); ?>
                                </div>
                            </div>
                            <div class="large-4 columns">
                                <?php echo $view['form']->label($form['utmName']); ?>
                                <div class="input-group">
                                    <?php echo $view['form']->widget($form['utmName']); ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="large-6 columns">
                                <?php echo $view['form']->label($form['utmTerm']); ?>
                                <div class="input-group">
                                    <?php echo $view['form']->widget($form['utmTerm']); ?>
                                </div>
                            </div>
                            <div class="large-6 columns">
                                <?php echo $view['form']->label($form['utmContent']); ?>
                                <div class="input-group">
                                    <?php echo $view['form']->widget($form['utmContent']); ?>
                                </div>
                            </div>
                        </div>
                        <div class="preview">
                            <label for="">Preview</label>
                            <div class="input-group">
                                <input type="text" class="input-group-field" id="preview_utm_url" readonly>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $view['form']->end($form); ?>
        </div>
    </div>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-link"></i> <span><?php echo $view['translator']->trans('link.url.list', [], 'link'); ?></span>
            </h3>
        </div>
        <div class="box-body " style="display: block;">
            <div class="short-link-table-wrapper">
                <table>
                    <thead>
                        <tr class="tr-edit-utm">
                            <th><?php echo $view['translator']->trans('link.table.url', [], 'link'); ?></th>
                            <th><?php echo $view['translator']->trans('link.table.created', [], 'link'); ?></th>
                            <th><?php echo $view['translator']->trans('link.table.short_url', [], 'link'); ?></th>
                            <th><?php echo $view['translator']->trans('link.table.clicks', [], 'link'); ?></th>
                            <th><?php echo $view['translator']->trans('link.table.status', [], 'link'); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($links as $link): ?>
                        <tr class="tr-edit-utm"
                            data-id="<?php echo $link->getId(); ?>"
                            data-url="<?php echo $link->getUrl(); ?>"
                            data-utm-enable="<?php echo intval($link->getUtmEnable()); ?>"
                            data-utm-source="<?php echo $link->getUtmSource(); ?>"
                            data-utm-medium="<?php echo $link->getUtmMedium(); ?>"
                            data-utm-name="<?php echo $link->getUtmName(); ?>"
                            data-utm-term="<?php echo $link->getUtmTerm(); ?>"
                            data-utm-content="<?php echo $link->getUtmContent(); ?>"
                        >
                            <td><a href="<?php echo $link->getUrlWithUtm(); ?>" target="_blank"><?php echo $link->getUrl(); ?></a></td>
                            <td><?php echo $link->getDateCreated()->format('H:i:s d.m.Y'); ?></td>
                            <td><a href="<?php echo $view['router']->url('wi_front_link_index', ['code' => $link->getCode()]); ?>" target="_blank"><?php echo $view['router']->url('wi_front_link_index', ['code' => $link->getCode()]); ?></a></td>
                            <td><?php echo $link->getCount(); ?></td>
                            <td><?php echo $link->getStatus(); ?></td>
                            <td>
                                <div class="edit-options">
                                    <button class="ellipsis-edit-button" type="button" data-toggle="dropdown-<?php echo $link->getId(); ?>"><i class="icon-ellipsis-vert"></i></button>
                                    <div class="dropdown-pane edit-options-block" data-position="bottom" data-alignment="right" id="dropdown-<?php echo $link->getId(); ?>" data-dropdown data-auto-focus="true">
                                        <ul>
                                            <li><a href="#" class="open-modal"><?php echo $view['translator']->trans('link.actions.edit', [], 'link'); ?></a></li>
                                            <li><a href="<?php echo $view['router']->path('wi_admin_link_change_status_disable_redirect', ['id' => $link->getId()]); ?>"><?php echo $view['translator']->trans('link.actions.disable_r', [], 'link'); ?></a></li>
                                            <li><a href="<?php echo $view['router']->path('wi_admin_link_change_status_disable_not_found', ['id' => $link->getId()]); ?>"><?php echo $view['translator']->trans('link.actions.disable_404', [], 'link'); ?></a></li>
                                            <li><a href="<?php echo $view['router']->path('wi_admin_link_change_status_delete', ['id' => $link->getId()]); ?>"><?php echo $view['translator']->trans('link.actions.delete', [], 'link'); ?></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

<!-- Modal -->
<div class="reveal" id="edit-modal" data-reveal>

    <div class="edit-configuration-modal-box">
        <?php echo $view['form']->start($form); ?>
            <div class="short-link-wrapper">
                <h2><?php echo $view['translator']->trans('link.form.edit_title', [], 'link'); ?></h2>
                <div class="short-link-form">
                    <div class="input-group">
                        <?php echo $view['form']->widget($formEdit['url']); ?>
                        <div class="input-group-button">
                            <button class="button" type="submit"><?php echo $view['translator']->trans('link.form.edit', [], 'link'); ?></button>
                        </div>

                    </div>

                    <div class="enable-utm">
                        <div class="enable-utm-switch switch small">
                            <?php echo $view['form']->errors($formEdit['utmEnable']); ?>
                            <?php echo $view['form']->widget($formEdit['utmEnable']); ?>
                            <label class="switch-paddle" for="<?php echo $formEdit->children['utmEnable']->vars['id']; ?>">
                                <span class="show-for-sr"><?php echo $view['translator']->trans('adminDelete.dataAdmin'); ?></span>
                                <span class="switch-active" aria-hidden="true"><?php echo $view['translator']->trans('yes'); ?></span>
                                <span class="switch-inactive" aria-hidden="true"><?php echo $view['translator']->trans('no'); ?></span>
                            </label>
                        </div>
                        <div class="enable-utm-info"><?php echo $view['translator']->trans('link.form.utmEnable', [], 'link'); ?></div>
                    </div>

                    <div class="short-link-utm" id="short-link-utm-edit">
                        <div class="row">
                            <div class="row">
                                <div class="large-4 columns">
                                    <?php echo $view['form']->label($formEdit['utmSource']); ?>
                                    <div class="input-group">
                                        <?php echo $view['form']->widget($formEdit['utmSource']); ?>
                                    </div>
                                </div>
                                <div class="large-4 columns">
                                    <?php echo $view['form']->label($formEdit['utmMedium']); ?>
                                    <div class="input-group">
                                        <?php echo $view['form']->widget($formEdit['utmMedium']); ?>
                                    </div>
                                </div>
                                <div class="large-4 columns">
                                    <?php echo $view['form']->label($formEdit['utmName']); ?>
                                    <div class="input-group">
                                        <?php echo $view['form']->widget($formEdit['utmName']); ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="large-6 columns">
                                    <?php echo $view['form']->label($formEdit['utmTerm']); ?>
                                    <div class="input-group">
                                        <?php echo $view['form']->widget($formEdit['utmTerm']); ?>
                                    </div>
                                </div>
                                <div class="large-6 columns">
                                    <?php echo $view['form']->label($formEdit['utmContent']); ?>
                                    <div class="input-group">
                                        <?php echo $view['form']->widget($formEdit['utmContent']); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo $view['form']->end($formEdit); ?>
    </div>

    <button type="button" class="close-button" data-close aria-label="Close modal">
        <span aria-hidden="true">&times;</span>
    </button>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/link.js') ?>"></script>
<?php $view['slots']->stop(); ?>
