<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_users_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.logTypes.List')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/users.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li><?php echo $view['translator']->trans('main-menu.web_portal'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_users_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.users.List'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_users_log_types_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.logTypes.List'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('users.listTitle'); ?> - <?php echo $view['translator']->trans('logTypesList.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-users color-menu-web-portal"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('logTypesList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
            </div>
            <h3 class="box-title"><i class="icon-th-list-outline"></i>
                <span><?php echo $view['translator']->trans('logTypesList.listSubTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="columns tableResp">
                    <table id="logTypesList"  class="trzyKolumny">
                        <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('logTypesList.table.id'); ?></th>
                            <th><?php echo $view['translator']->trans('logTypesList.table.name'); ?></th>
                            <th><?php echo $view['translator']->trans('logTypesList.table.type'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($logTypes as $logType): ?>
                            <tr>
                                <td><?php echo $logType->getId(); ?></td>
                                <td><?php echo $logType->getName(); ?></td>
                                <td>
                                    <?php if($logType->getType()=='I'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.info'); ?>
                                    <?php elseif ($logType->getType()=='W'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.warning'); ?>
                                    <?php elseif ($logType->getType()=='S'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.success'); ?>
                                    <?php elseif ($logType->getType()=='E'): ?>
                                        <?php echo $view['translator']->trans('logTypesList.type.error'); ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-12 columns">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_users_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/users.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
