<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('wi_admin_media_index'));
/** @var \Admin\WicmsBundle\Templating\Helper\MediaHelper $mediaHelper */
$mediaHelper = $view['media'];
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Admin\WicmsBundle\Templating\Helper\ConfigHelper $configHelper */
$configHelper = $view['config'];
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\RequestHelper $requestHelper */
$requestHelper = $view['request'];

$view['slots']->set('title', $translator->trans('title.media.List'));
$view['slots']->set('titleSite', $translator->trans('mediaList.subTitle'));
$view['slots']->set('titleDesc', $translator->trans('mediaList.desc'));
$view['slots']->set('titleIcon', '<i class="icon-picture-1 color-menu-content"></i>');
$view['slots']->set('helpRightPanel', '');
?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/media.css'); ?><?php echo $configHelper->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><?php echo $translator->trans('main-menu.content'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_media_index'); ?>"><?php echo $translator->trans('breadcrumbs.media.media'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="album-navigation-wrapper">
    <span class="you-are-here"><?php echo $translator->trans('media.navigation.you_are_here', [], 'media'); ?>:</span>
    <a href="<?php echo $view['router']->path('wi_admin_media_index'); ?>" class="folder"><?php echo $translator->trans('media.navigation.main_folder', [], 'media'); ?>/</a><?php if ($directory = $requestHelper->getParameter('directory')): ?><?php $path = ''; ?><?php foreach (array_filter(explode('/', $directory)) as $folder): ?><?php $path .= $folder.'/'; ?><a href="<?php echo $view['router']->path('wi_admin_media_index_dir', ['directory' => rtrim($path, '/')]); ?>" class="folder"><?php echo $folder; ?>/</a><?php endforeach; ?><?php endif; ?>
</div>
<p class="clearfix">
    <?php if ($mediaHelper->displayBackLink($currentDirectory)): ?>
        <a href="<?php echo $view['router']->path('wi_admin_media_index'); ?><?php echo $previousDirectory; ?>" class="button secondary tiny"><i class="icon-reply"></i> <?php echo $translator->trans('media.navigation.back', [], 'media'); ?></a>
    <?php endif; ?>
    <?php if ($mediaHelper->isNonReadonlyDirectory($requestHelper->getParameter('directory'), '') && $view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
        <a class="button tiny" id="media-button"><i class="icon-upload"></i><?php echo $translator->trans('media.navigation.add_files', [], 'media'); ?></a>
        <a class="button tiny" data-open="addFolder"><i class="icon-folder-add"></i> <?php echo $translator->trans('media.navigation.add_directory', [], 'media'); ?></a>
    <?php endif; ?>
    <span class="float-right">
        <span class="button tiny secondary media-view" data-view="grid"><i class="icon-th"></i></span>
        <span class="button tiny secondary media-view" data-view="list"><i class="icon-th-list"></i></span>
    </span>
</p>
<div class="media gallery-wrapper" id="media-drop-area" data-directory="<?php echo $requestHelper->getParameter('directory'); ?>">
    <div class="gallery-main-wrapper without-info" id="gallery-main">
        <?php if (! empty($directories)): ?>
            <h6><?php echo $translator->trans('media.items.directories', [], 'media'); ?></h6>
            <div class="items">
                <?php
                /** @var \Symfony\Component\Finder\SplFileInfo $directory */
                foreach ($directories as $i => $directory): ?>
                    <div class="item dir" data-url="<?php echo $view['router']->path('wi_admin_media_index_dir', ['directory' => $requestHelper->getParameter('directory').$directory->getFilename()]); ?>">
                        <div class="item-inner">
                            <div class="my-item-thumbnail">
                                <div class="my-item-thumbnail-inner">
                                    <i class="icon-folder"></i>
                                </div>
                            </div>
                            <div class="item-name">
                                <div class="item-name-inner">
                                    <div class="icon">
                                        <i class="icon-folder"></i>
                                    </div>
                                    <div class="name">
                                        <span title="<?php echo $directory->getFilename(); ?>"><?php echo $directory->getFilename(); ?></span>
                                    </div>
                                </div>
                            </div>
                            <?php if ($mediaHelper->isNonReadonlyDirectory($requestHelper->getParameter('directory'), $directory->getFilename()) && $view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
                                <div class="item-menu">
                                    <span class="file-manager-dropdown-btn" data-toggle="dropdown-<?php echo $i; ?>">
                                        <i class="icon-ellipsis-vert"></i>
                                    </span>
                                    <div class="dropdown-pane item-dropdown" data-position="bottom" data-alignment="right" id="dropdown-<?php echo $i; ?>" data-dropdown data-close-on-click="true">
                                        <ul class="no-bullet">
                                            <li><a data-open="rename-form" data-old-name="<?php echo $directory->getFilename(); ?>"><i class="icon-edit"></i> <?php echo $translator->trans('media.dir.rename.title', [], 'media'); ?></a></li>
                                            <li><a data-open="delete-form" data-name="<?php echo $directory->getFilename(); ?>"><i class="icon-cancel-circled2"></i> <?php echo $translator->trans('media.dir.delete.title', [], 'media'); ?></a></li>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <?php if (! empty($files)): ?>
            <h6><?php echo $translator->trans('media.items.files', [], 'media'); ?></h6>
            <div class="items">
                <?php
                /** @var \Symfony\Component\HttpFoundation\File\File $file */
                foreach ($files as $i => $file): ?>
                <?php $dimensions = $mediaHelper->isImage($file->getExtension()) ? getimagesize($file) : [null, null]; ?>
                    <div class="item"
                         data-info
                         data-filename="<?php echo $file->getFilename(); ?>"
                         data-link="<?php echo $file->link; ?>"
                         data-size="<?php echo $view['front']->formatBytes($file->getSize()); ?>"
                         data-dimension-width="<?php echo $dimensions[0]; ?>"
                         data-dimension-height="<?php echo $dimensions[1]; ?>"
                         data-is-image="<?php echo $mediaHelper->isImage($file->getExtension()) ? 'true' : 'false'; ?>"
                         data-icon="<?php echo $mediaHelper->getIcon($file->getExtension()); ?>"
                         data-extension="<?php echo $file->getExtension(); ?>"
                    >
                        <div class="item-inner">
                            <div class="my-item-thumbnail">
                                <div class="my-item-thumbnail-inner">
                                    <?php if ($mediaHelper->isImage($file->getExtension())): ?>
                                        <img src="<?php echo $file->link; ?>?thumb=200x200">
                                    <?php else: ?>
                                        <i class="<?php echo $mediaHelper->getIcon($file->getExtension()); ?>"></i>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="item-name">
                                <div class="item-name-inner">
                                    <div class="icon">
                                        <i class="<?php echo $mediaHelper->getIcon($file->getExtension()); ?>"></i>
                                    </div>
                                    <div class="name">
                                        <span title="<?php echo $file->getFilename(); ?>"><?php echo $file->getFilename(); ?></span>
                                    </div>
                                    <div class="item-menu">
                                        <span class="file-manager-dropdown-btn" data-toggle="dropdown-file-<?php echo $i; ?>">
                                            <i class="icon-ellipsis-vert"></i>
                                        </span>
                                        <div class="dropdown-pane item-dropdown" data-position="bottom" data-alignment="right" id="dropdown-file-<?php echo $i; ?>" data-dropdown data-close-on-click="true">
                                            <ul class="no-bullet">
                                            <?php if ($mediaHelper->isNonReadonlyFile($requestHelper->getParameter('directory')) && $view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
                                                <li><a data-open="rename-form" data-old-name="<?php echo $file->getFilename(); ?>"><i class="icon-edit"></i> <?php echo $translator->trans('media.file.rename.title', [], 'media'); ?></a></li>
                                                <li><a data-open="delete-form" data-name="<?php echo $file->getFilename(); ?>"><i class="icon-cancel-circled2"></i> <?php echo $translator->trans('media.file.delete.title', [], 'media'); ?></a></li>
                                            <?php endif; ?>
                                                <li><a href="<?php echo $file->link; ?>" download="<?php $file->getFilename(); ?>"><i class="icon-download"></i> <?php echo $translator->trans('media.file.download.title', [], 'media'); ?></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="gallery-info-wrapper hide" id="gallery-info">
        <div class="gallery-info-inner-wrapper">
            <div class="gallery-info-header">
                <div class="icon" id="media-info-icon"><i class="icon-folder"></i></div>
                <div class="name" id="media-info-name"></div>
            </div>
            <div class="gallery-info-tab-content">
                <div class="img">
                    <div class="icon" id="media-info-image">
                        <i class="icon-folder"></i>
                    </div>
                </div>
                <div class="details">
                    <p id="media-info-size"><strong><?php echo $translator->trans('media.info.size', [], 'media'); ?>:</strong> <span></span></p>
                    <p id="media-info-type"><strong><?php echo $translator->trans('media.info.type', [], 'media'); ?>:</strong> <span></span></p>
                    <p id="media-info-dimensions"><strong><?php echo $translator->trans('media.info.dimensions', [], 'media'); ?>:</strong> <span></span></p>

                    <div class="input-group clipboard gallery-picture-clipboard">
                        <span class="infoCopyUrl" style="opacity: 0; z-index: -1;"><span><?php echo $view['translator']->trans('galleries.details.copied'); ?></span></span>
                        <input type="text" id="media-info-url" class="input-group-field gallery_url" readonly value="">
                        <div class="input-group-button">
                            <button type="button" id="copy-to-clipboard" class="copy-to-clipboard button" data-tooltip title="<?php echo $view['translator']->trans('galleries.details.copy_to_clipboard'); ?>"><i class="icon-clipboard-2"></i></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
<?php /* Modals */ ?>
<?php echo $view->render($view['front']->getTemplateDir().'Media/Components/new-folder-modal.html.php', ['addFolderForm' => $addFolderForm]); ?>
<?php echo $view->render($view['front']->getTemplateDir().'Media/Components/rename-modal.html.php', ['renameForm' => $renameForm]); ?>
<?php echo $view->render($view['front']->getTemplateDir().'Media/Components/delete-modal.html.php', ['deleteForm' => $deleteForm]); ?>
<?php /* Upload progress */ ?>
<div class="tiny reveal upload-progress-wrapper" id="upload-progress-wrapper" data-reveal data-close-on-click="false" data-close-on-esc="false">
    <div class="upload-loader-wrapper">
        <div class="lds-roller"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
    </div>
    <h3><?php echo $translator->trans('media.files.upload.upload_files', [], 'media'); ?> <span id="current-number"></span> <?php echo $translator->trans('media.files.upload.of', [], 'media'); ?> <span id="total-number"></span></h3>
    <div class="upload-progress">
        <div id="upload-progress" class="progress" role="progressbar" tabindex="0" aria-valuemin="0" aria-valuemax="100">
            <span class="progress-meter" style="width: 0%">
                <p class="progress-meter-text">0%</p>
            </span>
        </div>
    </div>
    <div class="callout primary"><?php echo $translator->trans('media.files.upload.info', [], 'media'); ?></div>
</div>
<?php endif; ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js'); ?>" type="text/javascript"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$requestHelper->getLocale().'.js'); ?>" type="text/javascript"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/media.js'); ?>" type="text/javascript"></script>
<?php if ($view['security']->isGranted('ROLE_MEDIA_EDIT')): ?>
<script>const WI_ALLOWED_EXTENSIONS = '<?php echo $mediaHelper->getAllowegExtensions(); ?>';</script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/media-edit.js'); ?>"></script>
<?php endif; ?>
<?php $view['slots']->stop(); ?>
