<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.message.messageNew')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/faq.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li><a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_newsletter_messagecontent_edit', ['id' => $messageContent->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.message.messageNew'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('message.listTitle'); ?> - <?php echo $view['translator']->trans('message.subTitleEdit'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-mail"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('message.edit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <?php echo $view['form']->start($form, array('multipart' => true, 'attr' => array( 'id' => 'wi_admin_newsletter_messagecontent' ))); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configNews-dropdown">
                        <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configNews-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                            <li>
                                <a href="<?php echo $view['router']->path('wi_admin_newsletter_messagecontent_delete', ['id' => $messageContent->getId()]) ?>"  title="<?php echo $view['translator']->trans('message.edit.delete'); ?>">
                                    <span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('message.edit.delete'); ?></span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <h3 class="box-title">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('message.edit.boxTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('message.edit.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('message.edit.titleDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-10 columns">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['title']); ?>
                            </div>
                        <?php echo ($view['form']->errors($form['title']) ? $view['form']->widget($form['title'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['title'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('message.edit.content'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('message.edit.contentDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="news-add-form" >
                        <div class="formAlert <?php echo ($view['form']->errors($form['message']) ? "callout alert" : ""); ?>">
                            <?php echo $view['form']->errors($form['message']); ?>
                        </div>
                        <div class="formAlert callout alert" id="contentValidation">
                            <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                        </div>
                        <div id="messageText">
                            <?php echo $view['form']->widget($form['message']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('message.edit.campaign'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('message.edit.campaignDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns">
                            <div class="formAlert callout alert" id="contentValidationCat">
                            </div>
                            <?php echo ($view['form']->errors($form['campaign']) ? $view['form']->widget($form['campaign'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($form['campaign'])); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns"></div>
                <div class="large-10 columns">
                    <a href="<?php echo $view['router']->path('wi_admin_media_index'); ?>" class="button" target="_blank"><?php echo $view['translator']->trans('message.edit.image_management'); ?></a>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns"></div>
                <div class="large-10 columns">
                    <div id="messagePreview">
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="row">
    <div class="columns">
        <div class="news-add-form">
            <?php echo $view['form']->widget($form); ?>
            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
            </a>
        </div>
    </div>
</div>
    <?php echo $view['form']->end($form); ?>
    <?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/chosen/chosen.jquery.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/markdown/markdown-it.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
<?php $view['slots']->stop() ?>
