<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_news_index')); ?>
<?php $view['form']->setTheme($form, [':form_errors']); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.news.newsEdit')); ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css'); ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
    <li><?php echo $view['translator']->trans('main-menu.content'); ?></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_news_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.news.news'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_news_edit', array('id' => $news->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.news.newsEdit'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
    <?php echo $view['translator']->trans('news.listTitle'); ?> - <?php echo $view['translator']->trans('newsEdit.subTitle'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-comment-alt-1 color-menu-content"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc'); ?>
    <?php echo $view['translator']->trans('newsEdit.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('menuShowSite'); ?>
<div class="menu-show-site">
    <a  class="button warning tiny" href="<?php echo $view['router']->path('wi_front_news_show', ['id' => $news->getId(), 'slug' => $view['front']->slugify($news->getTitle()) ?: '-']); ?>" title="<?php echo $view['translator']->trans('top-bar.showArticle'); ?>" target="_blank">
        <i class="icon-monitor-1"></i>
        <span>
            <?php echo $view['translator']->trans('top-bar.showArticle'); ?>
        </span>
    </a>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel'); ?><?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-edit"></i> <span><?php echo $view['translator']->trans('newsEdit.boxTitle'); ?> - <?php echo $news->getTitle(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php echo $view['form']->start($form, array('multipart' => true, 'attr' => array( 'id' => 'newsNew' ))); ?>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.titleTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.titleDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['title']); ?>
                            <?php echo $view['form']->errors($form['title']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.imgTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.imgDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="callout alert small hide komunikatBleduImage" id="komunikatBleduImage">
                        <?php echo $view['translator']->trans('newsNew.form.imgError'); ?>
                    </div>
                    <div class="news-add-form">
                        <input type="hidden" name="crop_x" id="crop_x">
                        <input type="hidden" name="crop_y" id="crop_y">
                        <input type="hidden" name="crop_height" id="crop_height">
                        <input type="hidden" name="crop_width" id="crop_width">
                        <input type="hidden" name="cropSave" id="cropSave">

                        <div class="large reveal" id="windowModalEditCropper" data-reveal data-close-on-click="false">
                            <div class="containerCropper">
                                <img id="editCropperImage" data-id="<?php echo $news->getId(); ?>" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg'); ?>">
                            </div>
                            <div class="row buttonAddImage">
                                <div class="medium-12 columns">
                                    <button type="button" class="button" id="save_photo" data-close aria-label="Close modal"><i class="icon-ok"></i> <?php echo $view['translator']->trans('newsNew.form.saveImage'); ?></button>
                                    <button type="button" class="button secondary float-right"  data-close aria-label="Close modal"><i class="icon-cancel"></i> <?php echo $view['translator']->trans('Form.backShow'); ?></button>
                                </div>
                            </div>
                        </div>

                        <img id="editCropperPreview" class="previewImage thumbnail" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg'); ?>">
                        <label class="AddImage" for="news_file_photo" >
                            <input type="file" accept=".jpg,.jpeg,.png" name="file_photo" id="news_file_photo" class="InputFileHidden">
                            <span class="button" id="editImageDataFromParameter" type="button" cropper-width="<?php echo $view['config']->get('news.imageWidth'); ?>" cropper-height="<?php echo $view['config']->get('news.imageHeight'); ?>">
                                <i class="icon-upload"></i><?php echo $view['translator']->trans('newsNew.form.addImage'); ?>
                            </span>
                        </label>
                    </div>

                    <div id="image-wrapper" data-image-url="<?php echo $view['assets']->getUrl('media/assets/News/thumbnailS/'); ?>">
                        <ul class="image-list">
                        <?php foreach ($news->getImages() as $image): ?>
                            <li data-id="<?php echo $image->getId(); ?>">
                                <img src="<?php echo $view['assets']->getUrl($image->getImageUrl('thumbnailS')); ?>" alt="">
                                <a href="<?php echo $view['router']->path('wi_admin_news_delete_image', ['id' => $image->getId()]); ?>" class="remove-image">Usuń</a>
                            </li>
                        <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.shortTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.shortDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <?php echo $view['form']->widget($form['shortcut']); ?>
                            <?php echo $view['form']->errors($form['shortcut']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.textTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.textDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert callout alert" id="contentValidation">
                                <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                            </div>
                            <?php echo $view['form']->widget($form['content']); ?>
                            <?php echo $view['form']->errors($form['content']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong><?php echo $view['translator']->trans('newsNew.form.main_category.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.main_category.desc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['mainCategory']); ?>
                            <?php echo $view['form']->errors($form['mainCategory']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.catTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.catDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['categories']); ?>
                            <?php echo $view['form']->errors($form['categories']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong><?php echo $view['translator']->trans('newsNew.form.administrator.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.administrator.desc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['administrator']); ?>
                            <?php echo $view['form']->errors($form['administrator']); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
            </div>
            <!-- tools box -->
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('newsEdit.box2Title'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.movieTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.movieDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <?php echo $view['form']->widget($form['movie']); ?>
                    <?php echo $view['form']->errors($form['movie']); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.tagTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.tagDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <button class="addTag button tiny secondary <?php echo $news->getTags()->count() > 0 ? 'hide' : '' ?>" type="button"><span><?php echo $view['translator']->trans('newsEdit.form.buttonAddTag'); ?></span></button>
                            <div class="formAddTags <?php echo $news->getTags()->count() > 0 ? '' : 'hide' ?>">
                                <?php echo $view['form']->label($form['tags']); ?>
                                <?php $view['form']->widget($form['tags']); ?>
                                <?php echo $view['form']->errors($form['tags']); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.dateTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.dateDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['dateOfPublication']); ?>
                            <?php echo $view['form']->errors($form['dateOfPublication']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.status'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.statusDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['status']); ?>
                            <?php echo $view['form']->errors($form['status']); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-download"></i><span><?php echo $view['translator']->trans('newsNew.enableDownloadTitle'); ?></span></h3>
        </div>
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.gallery.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.gallery.desc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns">
                            <?php echo $view['form']->widget($form['gallery']); ?>
                            <?php echo $view['form']->errors($form['gallery']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.enableDownload.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.enableDownload.desc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <?php echo $view['form']->widget($form['enableDownload']); ?>
                    <?php echo $view['form']->errors($form['enableDownload']); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="box metaTags collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('newsEdit.metaTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.metaTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.metaDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaTitle']); ?>
                                <?php echo $view['form']->widget($form['metaTitle']); ?>
                                <?php echo $view['form']->errors($form['metaTitle']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaDescription']); ?>
                                <?php echo $view['form']->widget($form['metaDescription']); ?>
                                <?php echo $view['form']->errors($form['metaDescription']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaKeywords']); ?>
                                <?php echo $view['form']->widget($form['metaKeywords']); ?>
                                <?php echo $view['form']->errors($form['metaKeywords']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaCanonical']); ?>
                                <?php echo $view['form']->widget($form['metaCanonical']); ?>
                                <?php echo $view['form']->errors($form['metaCanonical']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaImage']); ?>
                                <?php echo $view['form']->widget($form['metaImage']); ?>
                                <?php echo $view['form']->errors($form['metaImage']); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="row">
    <div class=" columns">
        <div class="hide">
            <?php echo $view['form']->widget($form['file']); ?>
            <?php echo $view['form']->widget($form['imageUrl']); ?>
        </div>
        <div class="news-add-form">
            <?php echo $view['form']->widget($form); ?>
            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
            <?php echo $view['form']->end($form); ?>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_news_show', array('id' => $news->getId())); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
            </a>
        </div>
    </div>
</div>
<?php echo $view->render('Components/modalTinyMCE.html.php'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js'); ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js'); ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.full.min.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/jquery-ui-1.12.1/jquery-ui.min.js'); ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.js'); ?>"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js'); ?>"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js'); ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js'); ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news_edit.js'); ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js'); ?>" type="text/javascript"></script>
    <script>
        $(function () {
            $('.image-list').sortable({
                placeholder: "image-list-item-placeholder",
                update: function (e, ui) {
                    var sortedIDs = $('.image-list').sortable('toArray', { attribute: 'data-id' });
                    $.ajax({
                        type: 'POST',
                        data: {
                            ids: sortedIDs,
                        },
                        dataType: 'json',
                        url: Routing.generate('wi_admin_news_update_image_order', { id: <?php echo $news->getId(); ?> }),
                        success: function (response) {
                            console.log(response);
                        },
                    });
                },
            }).disableSelection();
        });
    </script>
<?php $view['slots']->stop(); ?>
