<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_news_index')); ?>
<?php $view['form']->setTheme($form, [':form_errors']); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.news.newsNew')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>">
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li><a href="<?php echo $view['router']->path('wi_admin_news_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.news.news'); ?></a></li>
    <li><a href="<?php echo $view['router']->path('wi_admin_news_new'); ?>"><?php echo $view['translator']->trans('breadcrumbs.news.newsNew'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('news.listTitle'); ?> - <?php echo $view['translator']->trans('newsNew.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-comment-alt-1 color-menu-content"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('newsNew.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<?php echo $view['form']->start($form, array('multipart' => true, 'attr' => array( 'id' => 'newsNew' ))); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('newsNew.boxTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php if($view['form']->errors($form)): ?>
            <div class="callout alert">
                <?php echo $view['form']->errors($form); ?>
            </div>
            <?php endif; ?>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('newsNew.form.titleTitle'); ?></strong>
                            <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.titleDesc'); ?>"></i>
                        </p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="medium-6 columns end">
                                <?php echo $view['form']->widget($form['title']); ?>
                                <?php echo $view['form']->errors($form['title']); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('newsNew.form.imgTitle'); ?></strong>
                            <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.imgDesc'); ?>"></i>
                        </p>
                    </div>
                    <div class="large-10 columns">
                        <div class="news-add-form">
                        <div class="callout alert small hide komunikatBleduImage" id="komunikatBleduImage">
                            <?php echo $view['translator']->trans('newsNew.form.imgError'); ?>
                        </div>
                            <?php if ($view['form']->errors($form['file'])): ?>
                                <div class="callout alert">
                                    <?php echo $view['form']->errors($form['file']); ?>
                                </div>
                            <?php endif; ?>
                            <div class="large reveal" id="windowModalCropper" data-reveal data-close-on-click="false">
                                <div class="containerCropper">
                                    <img id="cropperImage" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg') ?>" alt="">
                                </div>
                                <div class="row buttonAddImage">
                                    <div class="medium-12 columns">
                                        <button type="button" class="button" id="Wyslijfoto" data-close aria-label="Close modal"><i class="icon-ok"></i> <?php echo $view['translator']->trans('newsNew.form.saveImage'); ?></button>
                                        <button type="button" class="button secondary float-right"  data-close aria-label="Close modal"><i class="icon-cancel"></i> <?php echo $view['translator']->trans('Form.backShow'); ?></button>
                                    </div>
                                </div>
                            </div>
                            <?php echo $view['form']->widget($form['crop_x']); ?>
                            <?php echo $view['form']->widget($form['crop_y']); ?>
                            <?php echo $view['form']->widget($form['crop_height']); ?>
                            <?php echo $view['form']->widget($form['crop_width']); ?>
                            <?php echo $view['form']->widget($form['cropSave']); ?>

                            <img id="cropperPreview" class="previewImage thumbnail"  src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/img/noimage.jpg') ?>" alt="">
                            <label class="AddImage" for="wi_admin_newsbundle_news_file" >
                                <?php echo $view['form']->widget($form['file']); ?>
                                <span class="button" id="imageDataFromParameter" type="button" cropper-width="<?php echo $view['config']->get('news.imageWidth'); ?>" cropper-height="<?php echo $view['config']->get('news.imageHeight'); ?>">
                                        <i class="icon-upload"></i><?php echo $view['translator']->trans('newsNew.form.addImage'); ?>
                                </span>
                            </label>
                            <div class="formAlert">
                                <?php echo $view['form']->errors($form['imageUrl']); ?>
                            </div>
                            <div class="hiddenBlock">
                                <?php echo ($view['form']->errors($form['imageUrl']) ? $view['form']->widget($form['imageUrl'], array('attr' => array('class' =>'callout alert'))) : $view['form']->widget($form['imageUrl'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('newsNew.form.shortTitle'); ?></strong>
                            <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.shortDesc'); ?>"></i>
                        </p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="columns">
                                <div class="formAlert">
                                </div>
                                <?php echo $view['form']->widget($form['shortcut']); ?>
                                <?php echo $view['form']->errors($form['shortcut']); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="large-2 columns">
                        <p><strong><?php echo $view['translator']->trans('newsNew.form.textTitle'); ?></strong>
                            <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.textDesc'); ?>"></i>
                        </p>
                    </div>
                    <div class="large-10 columns">
                        <div class="row">
                            <div class="columns">
                                <div class="formAlert callout alert" id="contentValidation">
                                    <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                                </div>
                                <?php echo $view['form']->widget($form['content']); ?>
                                <?php echo $view['form']->errors($form['content']); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong><?php echo $view['translator']->trans('newsNew.form.main_category.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.main_category.desc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['mainCategory']); ?>
                            <?php echo $view['form']->errors($form['mainCategory']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.catTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.catDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['categories']); ?>
                            <?php echo $view['form']->errors($form['categories']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong><?php echo $view['translator']->trans('newsNew.form.administrator.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.administrator.desc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['administrator']); ?>
                            <?php echo $view['form']->errors($form['administrator']); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('newsNew.box2Title'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.movieTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.movieDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <?php echo $view['form']->widget($form['movie']); ?>
                    <?php echo $view['form']->errors($form['movie']); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.tagTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.tagDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <button class="addTag button tiny secondary" type="button"><span><?php echo $view['translator']->trans('newsNew.form.buttonAddTag'); ?></span></button>
                            <div class="formAddTags hide">
                                <?php echo $view['form']->label($form['tags']); ?>
                                <?php echo $view['form']->widget($form['tags']); ?>
                                <?php echo $view['form']->errors($form['tags']); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.dateTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.dateDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['dateOfPublication']); ?>
                            <?php echo $view['form']->errors($form['dateOfPublication']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.status'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.statusDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['status']); ?>
                            <?php echo $view['form']->errors($form['status']); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-download"></i><span><?php echo $view['translator']->trans('newsNew.enableDownloadTitle'); ?></span></h3>
        </div>
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsEdit.form.gallery.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsEdit.form.gallery.desc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns">
                            <?php echo $view['form']->widget($form['gallery']); ?>
                            <?php echo $view['form']->errors($form['gallery']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.enableDownload.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.enableDownload.desc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <?php echo $view['form']->widget($form['enableDownload']); ?>
                    <?php echo $view['form']->errors($form['enableDownload']); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="box metaTags collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('newsNew.metaTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('newsNew.form.metaTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('newsNew.form.metaDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaTitle']) ?>
                                <?php echo $view['form']->widget($form['metaTitle']); ?>
                                <?php echo $view['form']->errors($form['metaTitle']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaDescription']) ?>
                                <?php echo $view['form']->widget($form['metaDescription']); ?>
                                <?php echo $view['form']->errors($form['metaDescription']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaKeywords']) ?>
                                <?php echo $view['form']->widget($form['metaKeywords']); ?>
                                <?php echo $view['form']->errors($form['metaKeywords']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaCanonical']) ?>
                                <?php echo $view['form']->widget($form['metaCanonical']); ?>
                                <?php echo $view['form']->errors($form['metaCanonical']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaImage']) ?>
                                <?php echo $view['form']->widget($form['metaImage']); ?>
                                <?php echo $view['form']->errors($form['metaImage']); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="row">
    <div class=" columns">
        <div class="callout alert small hide komunikatBleduImage" id="komunikatBleduImage">
            <?php echo $view['translator']->trans('newsNew.form.imgError'); ?>
        </div>
        <div class="news-add-form">
            <?php echo $view['form']->widget($form); ?>
            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.create'); ?>">
                <i class="icon-plus"></i> <?php echo $view['translator']->trans('Form.create'); ?>
            </button>

            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_news_index'); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
            </a>
        </div>
    </div>
</div>
    <?php echo $view['form']->end($form); ?>

<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/cropper/dist/cropper.min.js') ?>"></script>
    <script type="text/javascript" src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.full.min.js') ?>"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/news.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
