<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_offer_offer_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.offers.offer.index')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.modules_addons'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_offer_offer_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.offers.offer.index'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('offers.offer.index.title'); ?> - <?php echo $view['translator']->trans('offers.offer.index.subtitle'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-megaphone color-menu-web-portal"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('offers.offer.index.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <?php if ($view['security']->isGranted('ROLE_OFFER_EDIT')): ?>
                <a href="<?php echo $view['router']->path('wi_admin_offer_offer_new'); ?>" title="<?php echo $view['translator']->trans('offers.offer.add'); ?>" class="button tiny primary buttonAddNew"><i class="icon-megaphone"></i> <?php echo $view['translator']->trans('offers.offer.add'); ?></a>
            <?php endif; ?>
            <span class="box-btn" data-toggle="dropdown"><i class="icon-ellipsis-vert"></i></span>
            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown" data-dropdown data-close-on-click="true">
                <ul class="no-bullet">
                    <li><a href="<?php echo $view['router']->path('wi_admin_offer_category_index'); ?>" title="<?php echo $view['translator']->trans('offers.category.manage'); ?>"><span><i class="icon-folder-2"></i> <?php echo $view['translator']->trans('offers.category.manage'); ?></span></a></li>
                    <?php if ($view['security']->isGranted('ROLE_OFFER_EDIT')): ?>
                        <li><a href="<?php echo $view['router']->path('wi_admin_offer_offer_new'); ?>" title="<?php echo $view['translator']->trans('offers.offer.add'); ?>"><span><i class="icon-megaphone"></i> <?php echo $view['translator']->trans('offers.offer.add'); ?></span></a></li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
        <h3 class="box-title"><i class="icon-megaphone"></i><span><?php echo $view['translator']->trans('offers.offer.index.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns tableResp">
                <table id="file-category-list" class="display" style="width:100%;">
                    <thead>
                        <tr>
                            <th><?php echo $view['knp_pagination']->sortable($offers, $view['translator']->trans('offers.offer.table.id'), 'o.id'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($offers, $view['translator']->trans('offers.offer.table.owner'), 'u.email'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($offers, $view['translator']->trans('offers.offer.table.content'), 'o.content'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($offers, $view['translator']->trans('offers.offer.table.price'), 'o.price'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($offers, $view['translator']->trans('offers.offer.table.location'), 'o.city'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($offers, $view['translator']->trans('offers.offer.table.categories'), 'c.name'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($offers, $view['translator']->trans('offers.offer.table.published_on'), 'o.dateOfPublication'); ?></th>
                            <th><?php echo $view['knp_pagination']->sortable($offers, $view['translator']->trans('offers.offer.table.expire_at'), 'o.dateExpired'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($offers as $offer): ?>
                        <tr>
                            <td><?php echo $offer->getId(); ?></td>
                            <td><?php echo $offer->getUser()->getEmail(); ?></td>
                            <td>
                                <?php echo mb_substr(strip_tags($offer->getContent()), 0, 50); ?><?php if (mb_strlen($offer->getContent()) > 50): ?>...<?php endif; ?>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <a href="<?php echo $view['router']->path('wi_admin_offer_offer_show', ['id' => $offer->getId()]); ?>"><i class="icon-eye-1"></i><?php echo $view['translator']->trans('Table.showButton'); ?></a>
                                        <?php if ($view['security']->isGranted('ROLE_OFFER_EDIT')): ?>
                                             / <a href="<?php echo $view['router']->path('wi_admin_offer_offer_edit', ['id' => $offer->getId()]); ?>"><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td><?php echo number_format($offer->getPrice(), 2, ',', ' '); ?></td>
                            <td><?php echo $offer->getCity(); ?>, <?php echo $offer->getVoivodeshipById(); ?></td>
                            <td>
                            <?php foreach ($offer->getCategories() as $category): ?>
                                <span class="label info secondary tiny" style="margin-bottom:2px;"><?php echo $category->getName(); ?></span>
                            <?php endforeach; ?>
                            </td>
                            <td>
                            <?php if ($offer->getDateOfPublication()): ?>
                                <?php echo $offer->getDateOfPublication()->format('d.m.Y'); ?>
                            <?php endif; ?>
                            </td>
                            <td>
                            <?php if ($offer->getDateExpired()): ?>
                                <?php echo $offer->getDateExpired()->format('d.m.Y'); ?>
                            <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="medium-6 columns">
            </div>
            <div class="medium-6 columns paginationBox">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                    'knp_pagination' => $offers,
                ]); ?>

                <?php echo $view['knp_pagination']->render($offers); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/offer.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
