<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_offer_offer_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.offers.offer.show')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.modules_addons'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_offer_offer_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.offers.offer.index'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_offer_offer_show', ['id' => $offer->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.offers.offer.show'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('offers.offer.index.title'); ?> - <?php echo $view['translator']->trans('offers.offer.index.subtitle'); ?> - <?php echo $view['translator']->trans('offers.offer.show.subtitle'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-megaphone color-menu-web-portal"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('offers.offer.show.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title"><i class="icon-megaphone"></i><span><?php echo $view['translator']->trans('offers.offer.show.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p><strong><?php echo $view['translator']->trans('offers.offer.table.content'); ?></strong>:</p>
            </div>
            <div class="large-10 columns">
                <div class="callout"><?php echo nl2br($offer->getContent()); ?></div>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns"></div>
            <div class="large-10 columns">
                <p><strong><?php echo $view['translator']->trans('offers.offer.table.price'); ?></strong>: <?php echo number_format($offer->getPrice(), 2, ',', ''); ?></p>
                <p><strong><?php echo $view['translator']->trans('offers.offer.table.location'); ?></strong>: <?php echo $offer->getLocation(); ?></p>
                <p><strong><?php echo $view['translator']->trans('offers.offer.table.published_on'); ?></strong>: <?php if ($offer->getDateOfPublication()): ?><?php echo $offer->getDateOfPublication()->format('d.m.Y'); ?><?php endif; ?></p>
                <p><strong><?php echo $view['translator']->trans('offers.offer.table.expire_at'); ?></strong>: <?php if ($offer->getDateExpired()): ?><?php echo $offer->getDateExpired()->format('d.m.Y'); ?><?php endif; ?></p>
                <p><strong><?php echo $view['translator']->trans('offers.offer.table.owner'); ?></strong>: <?php echo $offer->getUser()->getEmail(); ?></p>
                <p><strong><?php echo $view['translator']->trans('offers.offer.table.contractor'); ?></strong>: <?php if ($offer->getContractor()): ?><?php echo $offer->getContractor()->getEmail(); ?><?php else: ?>—<?php endif; ?></p>
                <p>
                    <strong><?php echo $view['translator']->trans('offers.offer.table.categories'); ?></strong>:
                    <?php if ($offer->getCategories()->count() > 0): ?>
                        <?php foreach ($offer->getCategories() as $category): ?>
                            <span class="label info secondary tiny" style="margin-bottom:2px;"><?php echo $category->getName(); ?></span>
                        <?php endforeach ?>
                    <?php else: ?>—<?php endif ?>
                </p>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns"></div>
            <div class="large-10 columns">
                <?php if ($view['security']->isGranted('ROLE_OFFER_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('wi_admin_offer_offer_edit', array('id' => $offer->getId())); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                        <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                    </a>
                <?php endif; ?>
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_offer_offer_index'); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                </a>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/offer.js') ?>"></script>
<?php $view['slots']->stop(); ?>
