<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_offer_offer_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.offers.category.index')); ?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/news.css'); ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.modules_addons'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_offer_offer_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.offers.offer.index'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_offer_category_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.offers.category.index'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('titleSite'); ?>
<?php echo $view['translator']->trans('offers.offer.index.title'); ?> - <?php echo $view['translator']->trans('offers.category.index.subtitle'); ?>
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-megaphone color-menu-web-portal"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc'); ?>
<?php echo $view['translator']->trans('offers.category.index.desc'); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <?php if ($view['security']->isGranted('ROLE_OFFER_EDIT')): ?>
            <div class="pull-right box-tools">
                <a href="<?php echo $view['router']->path('wi_admin_offer_category_new'); ?>" title="<?php echo $view['translator']->trans('offers.category.add'); ?>" class="button tiny primary buttonAddNew"><i class="icon-folder-add"></i> <?php echo $view['translator']->trans('offers.category.add'); ?></a>
            </div>
        <?php endif ?>
        <h3 class="box-title"><i class="icon-folder-2"></i><span><?php echo $view['translator']->trans('offers.category.index.subtitle'); ?></span></h3>
    </div>
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="columns tableResp">
                <table id="file-category-list" class="display" style="width:100%;">
                    <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('offers.category.table.id'); ?></th>
                            <th><?php echo $view['translator']->trans('offers.category.table.name'); ?></th>
                            <th><?php echo $view['translator']->trans('offers.category.table.color'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($categories as $category): ?>
                        <tr>
                            <td><?php echo $category->getId(); ?></td>
                            <td>
                                <?php echo $category->getName(); ?>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <?php if ($view['security']->isGranted('ROLE_OFFER_EDIT')): ?>
                                            <a href="<?php echo $view['router']->path('wi_admin_offer_category_edit', ['id' => $category->getId()]); ?>"><i class="icon-edit-1"></i><?php echo $view['translator']->trans('Table.editButton'); ?></a>
                                             / <a href="<?php echo $view['router']->path('wi_admin_offer_category_delete', ['id' => $category->getId()]); ?>"><i class="icon-cancel-circled-outline"></i><?php echo $view['translator']->trans('Table.deleteButton'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td><?php echo $category->getColor(); ?></td>
                        </tr>
                    <?php endforeach ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns"></div>
            <div class="large-10 columns">
                <div class="news-add-form">
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_offer_offer_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>
