<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index')); ?>
<?php $view['form']->setTheme($form, [':form_errors']); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pages.Edit')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_edit', array('id' => $page->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.Edit'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('pagesEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-doc-2 color-menu-content"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('pagesEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('menuShowSite'); ?>
<div class="menu-show-site">
    <a  class="button success tiny" href="<?php echo $view['router']->path('wi_front_page_index', ['id' => $page->getId(), 'slug' => $view['front']->slugify($page->getTitle()) ?: '-']); ?>" title="<?php echo $view['translator']->trans('top-bar.showArticle'); ?>" target="_blank">
        <i class="icon-monitor-1"></i>
        <span><?php echo $view['translator']->trans('top-bar.showArticle'); ?></span>
    </a>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form, ['attr' => ['id' => 'wi_admin_pagebundle_page']]); ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-edit"></i> <span><?php echo $view['translator']->trans('pagesEdit.boxTitle'); ?> - <?php echo $page->getTitle(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesEdit.form.titleTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('pagesEdit.form.titleDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['title']); ?>
                            <?php echo $view['form']->errors($form['title']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesEdit.form.textTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('pagesEdit.form.textDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="columns">
                            <div class="formAlert callout alert" id="contentValidation">
                                <?php echo $view['translator']->trans('This value should not be blank.'); ?>
                            </div>
                            <?php echo $view['form']->widget($form['content']); ?>
                            <?php echo $view['form']->errors($form['content']); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="box collapsed-box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
        </div>
        <!-- tools box -->
        <h3 class="box-title" data-widget="collapse">
            <i class="icon-doc-add"></i> <span><?php echo $view['translator']->trans('newsEdit.box2Title'); ?></span>
        </h3>
    </div>
    <!-- /.box-header -->
    <div class="box-body " style="display: none;">
        <?php if(isset($form['group'])): ?>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesEdit.form.groupTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('pagesEdit.form.groupDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <?php echo $view['form']->widget($form['group']); ?>
                            <?php echo $view['form']->errors($form['group']); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

    <div class="box collapsed-box">
        <div class="box-header bg-transparent">
            <div class="pull-right box-tools">
                <span><i class="icon-up-open collapseExpand" data-widget="collapse"></i></span>
            </div>
            <h3 class="box-title" data-widget="collapse"><i class="icon-download"></i><span><?php echo $view['translator']->trans('newsNew.enableDownloadTitle'); ?></span></h3>
        </div>
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesNew.form.gallery.title'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('pagesNew.form.gallery.desc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns">
                            <?php echo $view['form']->widget($form['gallery']); ?>
                            <?php echo $view['form']->errors($form['gallery']); ?>
                        </div>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong><?php echo $view['translator']->trans('page.form.banner_set.title', [], 'page'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('page.form.banner_set.desc', [], 'page'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns">
                            <?php echo $view['form']->widget($form['bannerSet']); ?>
                            <?php echo $view['form']->errors($form['bannerSet']); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="box metaTags collapsed-box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span>
                    <i class="icon-up-open" data-widget="collapse"></i>
                </span>
            </div>
            <h3 class="box-title" data-widget="collapse">
                <i class="icon-chart-bar-2"></i> <span><?php echo $view['translator']->trans('pagesEdit.metaTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: none;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('pagesEdit.form.metaTitle'); ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('pagesEdit.form.metaDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-6 columns end">
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaTitle']) ?>
                                <?php echo $view['form']->widget($form['metaTitle']); ?>
                                <?php echo $view['form']->errors($form['metaTitle']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaDescription']) ?>
                                <?php echo $view['form']->widget($form['metaDescription']); ?>
                                <?php echo $view['form']->errors($form['metaDescription']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaKeywords']) ?>
                                <?php echo $view['form']->widget($form['metaKeywords']); ?>
                                <?php echo $view['form']->errors($form['metaKeywords']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaCanonical']) ?>
                                <?php echo $view['form']->widget($form['metaCanonical']); ?>
                                <?php echo $view['form']->errors($form['metaCanonical']); ?>
                            </div>
                            <div class="news-add-form">
                                <?php echo $view['form']->label($form['metaImage']) ?>
                                <?php echo $view['form']->widget($form['metaImage']); ?>
                                <?php echo $view['form']->errors($form['metaImage']); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <?php echo $view['form']->widget($form); ?>
            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_pages_show', array('id' => $page->getId())); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
            </a>
        </div>
    </div>
</div>

    <?php echo $view['form']->end($form); ?>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/plupload.full.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/plupload-2.3.1/js/i18n/'.$view['request']->getLocale().'.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>" type="text/javascript"></script>
    <script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js') ?>'></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>

