<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index'));
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Admin\WicmsBundle\Templating\Helper\ConfigHelper $configHelper */
$configHelper = $view['config'];

$view['slots']->set('title', $translator->trans('title.page.index', [], 'page'));
$view['slots']->set('titleSite', $translator->trans('page.index.title', [], 'page').' - '.$translator->trans('page.index.subtitle', [], 'page'));
$view['slots']->set('titleDesc', $translator->trans('page.index.desc', [], 'page'));
$view['slots']->set('titleIcon', '<i class="icon-doc-2 color-menu-content"></i>');
$view['slots']->set('helpRightPanel', '');
?>

<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css').$configHelper->getParameter('vStyle'); ?>">
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.content'); ?></li>
<li><a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $translator->trans('breadcrumbs.page.index', [], 'page'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php
/**
 * Render page groups tree.
 *
 * @param $pageGroups
 * @param string $prefix
 * @param string $html
 * @param string $boxListClass
 * @return string
 */
$displayPageGroupsWithPages = function ($pageGroups, $prefix = '', $boxListClass = '', $html = '') use (&$displayPageGroupsWithPages, $view) {
    foreach ($pageGroups as $key => $pageGroup) {
        $html .= $view->render($view['front']->getTemplateDir().'Page/Components/box.html.php', [
            'pageGroup' => $pageGroup,
            'prefix' => $prefix,
            'key' => $key,
            'html' => $html,
            'boxListClass' => $boxListClass,
            'displayPageGroupsWithPages' => $displayPageGroupsWithPages,
        ]);
    }

    return $html;
};
?>
<div class="box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <span class="box-btn" data-toggle="configGroup-dropdown"><i class="icon-ellipsis-vert"></i></span>
            <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="left" id="configGroup-dropdown" data-dropdown data-close-on-click="true">
                <ul class="no-bullet">
                    <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                    <li><a href="<?php echo $view['router']->path('wi_admin_pages_new'); ?>" title="<?php echo $view['translator']->trans('pagesList.add'); ?>"><span><i class="icon-doc-add"></i><?php echo $view['translator']->trans('pagesList.add'); ?></span></a></li>
                    <li><a href="<?php echo $view['router']->path('wi_admin_page_groups_new', ['b' => 'p']); ?>" title="<?php echo $view['translator']->trans('pagesList.addNewGroup'); ?>"><span><i class="icon-folder-add"></i><?php echo $view['translator']->trans('pagesList.addNewGroup'); ?></span></a></li>
                    <?php endif; ?>
                    <li><a href="<?php echo $view['router']->path('wi_admin_page_groups_index'); ?>" title="<?php echo $view['translator']->trans('pagesList.menageGroup'); ?>"><span><i class="icon-folder-2"></i><?php echo $view['translator']->trans('pagesList.menageGroup'); ?></span></a></li>
                </ul>
            </div>
        </div>
        <h3 class="box-title"><i class="icon-search"></i><span><?php echo $view['translator']->trans('pagesList.searchBox'); ?>:</span></h3>
        <form action="<?php echo $view['router']->path('wi_admin_pages_index'); ?>" method="get" id="searchBoxForm">
            <input type="search" name="q" value="<?php echo $view['request']->getParameter('q'); ?>" placeholder="<?php echo $view['translator']->trans('pagesList.search'); ?>">
        </form>
        <?php if(! is_null($view['request']->getParameter('q'))): ?>
            <a class="clearFilter" href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>" title="<?php echo $view['translator']->trans('newsList.clearFilter'); ?>"><i class="icon-cancel"></i></a>
        <?php endif; ?>
    </div>
</div>
<span class="countPagesGroups" date-pageGroups="<?php echo $pageGroups->count(); ?>"></span>
<?php echo $displayPageGroupsWithPages($pageGroups); ?>
<script>var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';</script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
