<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_pages_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pagesGroup.Edit')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/css/select2.min.css') ?>" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_page_groups_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pagesGroup.List'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_page_groups_edit', ['id' => $pageGroup->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.pagesGroup.Edit'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('groupEdit.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-doc-2 color-menu-content"></i>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('groupEdit.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($edit_form) ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <h3 class="box-title">
                <i class="icon-edit"></i>
                <span><?php echo $view['translator']->trans('groupEdit.listSubTitle'); ?> - <?php echo $pageGroup->getName();?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <?php if ($view['form']->errors($edit_form)): ?>
                <div class="alert callout small">
                    <?php echo $view['form']->errors($edit_form); ?>
                </div>
            <?php endif; ?>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['form']->label($edit_form['name']) ?></strong>
                        <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $view['translator']->trans('groupEdit.formDesc'); ?>"></i>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-12 large-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['name']) ?>
                            </div>
                            <?php echo($view['form']->errors($edit_form['name']) ? $view['form']->widget($edit_form['name'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($edit_form['name'])) ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p>
                        <strong><?php echo $view['form']->label($edit_form['orderNr']) ?></strong>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="small-6 medium-4 large-2 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['orderNr']) ?>
                            </div>
                            <?php echo($view['form']->errors($edit_form['orderNr']) ? $view['form']->widget($edit_form['orderNr'], array('attr' => array('class' => 'callout alert'))) : $view['form']->widget($edit_form['orderNr'])) ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['form']->label($edit_form['parent']) ?></strong>

                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="row">
                        <div class="medium-12 large-6 columns end">
                            <div class="formAlert">
                                <?php echo $view['form']->errors($edit_form['parent']) ?>
                            </div>
                            <?php echo($view['form']->errors($edit_form['parent']) ? $view['form']->widget($edit_form['parent'], array('attr' => array('class' => 'callout alert chosenSelectGroup'))) : $view['form']->widget($edit_form['parent'])) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div class="row">
    <div class=" columns">
        <div class="wi-konatkt-form">
            <button class="button" href="#" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>">
                <i class="icon-edit"></i>
                <?php echo $view['translator']->trans('Form.send'); ?>
            </button>
            <?php echo $view['form']->end($edit_form) ?>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_page_groups_show', array('id' => $pageGroup->getId())); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
            </a>
        </div>
    </div>
</div>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/select2/dist/js/select2.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>
