<?php $view->extend('::wicms.html.php'); ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_news_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.pagesGroup.List')) ?>

<?php $view['slots']->start('stylesheets'); ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css') ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>"  rel="stylesheet" type="text/css" />
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/pages.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>" rel="stylesheet" type="text/css" />
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pages.pages'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_page_groups_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.pagesGroup.List'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('pages.listTitle'); ?> - <?php echo $view['translator']->trans('groupList.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-doc-2 color-menu-content"></i>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('groupList.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body'); ?>
    <?php
    /**
     * Render page groups tree.
     *
     * @param $pageGroups
     * @param string $prefix
     * @param string $html
     * @return string
     */
    $displayPageGroupsTree = function ($pageGroups, $prefix = '', $html = '') use (&$displayPageGroupsTree, $view) {
        foreach ($pageGroups as $key => $pageGroup) {
            $html .= $view->render($view['front']->getTemplateDir().'PageGroup/Components/row.html.php', [
                'pageGroup' => $pageGroup,
                'prefix' => $prefix,
                'hasPrev' => ! is_null($pageGroups->get($key - 1)),
                'hasNext' => ! is_null($pageGroups->get($key + 1)),
            ]);

            // Jeśli są podgrupy.
            if ($pageGroup->getChildren()->count()) {
                $html .= $displayPageGroupsTree($pageGroup->getChildren(), $prefix . '<span class="cat-prefix">&nbsp;</span>');
            }
        }

        return $html;
    };
    ?>

    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <?php if ($view['security']->isGranted('ROLE_PAGES_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('wi_admin_page_groups_new') ?>" title="<?php echo $view['translator']->trans('groupList.add'); ?>" class="button tiny primary buttonAddNew">
                        <i class="icon-folder-add"></i><?php echo $view['translator']->trans('groupList.add'); ?>
                    </a>
                <?php endif; ?>
            </div>
            <h3 class="box-title"><i class="icon-th-list-outline"></i>
                <span><?php echo $view['translator']->trans('groupList.listSubTitle'); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="columns tableResp">
                    <table id="groupList" class="catList row-border unstriped hover" style="width:100%">
                        <thead>
                        <tr>
                            <th><?php echo $view['translator']->trans('groupList.table.name'); ?></th>
                            <th></th>
                            <th><?php echo $view['translator']->trans('groupList.table.date'); ?></th>
                            <th><?php echo $view['translator']->trans('groupList.table.OrderNr'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php echo $displayPageGroupsTree($pageGroups); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row navigationBottom">
                <div class="columns">
                    <a class="button secondary" href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backListPages'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <script>
        var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
    </script>
<?php $view['slots']->stop(); ?>


<?php $view['slots']->start('javascript'); ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js') ?>" type="text/javascript"></script>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/pages.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop(); ?>

