<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('admin_popup_index'));
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];

$view['slots']->set('title', $translator->trans('title.popup.delete', [], 'popup'));
$view['slots']->set('titleSite', $translator->trans('popup.delete.title', [], 'popup'));
$view['slots']->set('titleDesc', $translator->trans('popup.delete.desc', [], 'popup'));
$view['slots']->set('titleIcon', '<i class="icon-popup-5 color-menu-template-extension"></i>');
$view['slots']->set('helpRightPanel', '');
?>
<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.template_extension'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_popup_index'); ?>"><?php echo $translator->trans('breadcrumbs.popup.index', [], 'popup'); ?></a></li>
<li><a href="<?php echo $view['router']->path('admin_popup_delete', ['id' => $popup->getId()]); ?>"><?php echo $translator->trans('breadcrumbs.popup.delete', [], 'popup'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title">
            <i class="icon-popup-5"></i> <span><?php echo $translator->trans('popup.delete.subtitle', [], 'popup'); ?></span>
        </h3>
    </div>
    <div class="box-body" style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $translator->trans('popup.delete.confirm', [], 'popup'); ?></strong></p>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($form['delete']); ?>
                    <?php echo $view['form']->widget($form['delete']); ?>
                </div>
                <button type="submit" id="AdminDeleteInput" class="button alert tiny" value="<?php echo $translator->trans('Form.delete'); ?>" disabled><i class="icon-cancel-circled"></i><?php echo $translator->trans('adminDelete.delete'); ?></button>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <a class="button secondary float-right" href="<?php echo $view['router']->path('admin_popup_index'); ?>"><i class="icon-reply"></i> <?php echo $translator->trans('Form.backShow'); ?></a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/popup.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
