<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('admin_popup_index'));
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];

$view['slots']->set('title', $translator->trans('title.popup.edit', [], 'popup'));
$view['slots']->set('titleSite', $translator->trans('popup.edit.title', [], 'popup'));
$view['slots']->set('titleDesc', $translator->trans('popup.edit.desc', [], 'popup'));
$view['slots']->set('titleIcon', '<i class="icon-popup-5 color-menu-template-extension"></i>');
$view['slots']->set('helpRightPanel', '');
?>
<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.css'); ?>">
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.template_extension'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_popup_index'); ?>"><?php echo $translator->trans('breadcrumbs.popup.index', [], 'popup'); ?></a></li>
<li><a href="<?php echo $view['router']->path('admin_popup_edit', ['id' => $popup->getId()]); ?>"><?php echo $translator->trans('breadcrumbs.popup.edit', [], 'popup'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<?php echo $view['form']->start($form); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <h3 class="box-title">
            <i class="icon-popup-5"></i> <span><?php echo $translator->trans('popup.edit.subtitle', [], 'popup'); ?></span>
        </h3>
    </div>
    <div class="box-body" style="display: block;">
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $translator->trans('popup.form.title.title', [], 'popup'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('popup.form.title.desc', [], 'popup'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['title']); ?></div>
                <?php echo $view['form']->widget($form['title'], [
                    'attr' => [
                        'class' => ($form['title']->vars['attr']['class'] ?? '') . (! $form['title']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $translator->trans('popup.form.content.title', [], 'popup'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('popup.form.content.desc', [], 'popup'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['content']); ?></div>
                <?php echo $view['form']->widget($form['content'], [
                    'attr' => [
                        'class' => ($form['content']->vars['attr']['class'] ?? '') . (! $form['content']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $translator->trans('popup.form.date_start.title', [], 'popup'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('popup.form.date_start.desc', [], 'popup'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['dateStart']); ?></div>
                <?php echo $view['form']->widget($form['dateStart'], [
                    'attr' => [
                        'class' => ($form['dateStart']->vars['attr']['class'] ?? '') . (! $form['dateStart']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $translator->trans('popup.form.date_end.title', [], 'popup'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('popup.form.date_end.desc', [], 'popup'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['dateEnd']); ?></div>
                <?php echo $view['form']->widget($form['dateEnd'], [
                    'attr' => [
                        'class' => ($form['dateEnd']->vars['attr']['class'] ?? '') . (! $form['dateEnd']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $translator->trans('popup.form.duration.title', [], 'popup'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('popup.form.duration.desc', [], 'popup'); ?>"></i>
                </p>
            </div>
            <div class="large-2 columns end">
                <div class="formAlert"><?php echo $view['form']->errors($form['duration']); ?></div>
                <?php echo $view['form']->widget($form['duration'], [
                    'attr' => [
                        'class' => ($form['duration']->vars['attr']['class'] ?? '') . (! $form['duration']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $translator->trans('popup.form.css_container.title', [], 'popup'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('popup.form.css_container.desc', [], 'popup'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['cssContainer']); ?></div>
                <?php echo $view['form']->widget($form['cssContainer'], [
                    'attr' => [
                        'class' => ($form['cssContainer']->vars['attr']['class'] ?? '') . (! $form['cssContainer']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
        <div class="row">
            <div class="large-2 columns">
                <p>
                    <strong><?php echo $translator->trans('popup.form.css_background.title', [], 'popup'); ?></strong>
                    <i class="icon-help-circled helpIcon" data-tooltip title="<?php echo $translator->trans('popup.form.css_background.desc', [], 'popup'); ?>"></i>
                </p>
            </div>
            <div class="large-10 columns">
                <div class="formAlert"><?php echo $view['form']->errors($form['cssBackground']); ?></div>
                <?php echo $view['form']->widget($form['cssBackground'], [
                    'attr' => [
                        'class' => ($form['cssBackground']->vars['attr']['class'] ?? '') . (! $form['cssBackground']->vars['valid'] ? ' callout alert' : null),
                    ],
                ]); ?>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class=" columns">
        <div class="news-add-form">
            <button class="button" type="submit" value="<?php echo $view['translator']->trans('Form.send'); ?>"><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.send'); ?></button>
            <a class="button secondary float-right" href="<?php echo $view['router']->path('admin_popup_index'); ?>"><i class="icon-reply"></i> <?php echo $translator->trans('Form.backShow'); ?></a>
        </div>
    </div>
</div>
<?php echo $view['form']->end($form); ?>
<?php echo $view->render('Components/modalTinyMCE.html.php') ?>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/date-dropdown/jquery.datetimepicker.js'); ?>"></script>
<script src='<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/tinymce/tinymce.min.js'); ?>'></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/tinyMCE/tinyMCE.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/popup.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
