<?php $view->extend('::wicms.html.php');
$this->addGlobal('menuIsActive', $view['router']->path('admin_popup_index'));
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Admin\WicmsBundle\Templating\Helper\ConfigHelper $configHelper */
$configHelper = $view['config'];
/** @var \Knp\Bundle\PaginatorBundle\Templating\PaginationHelper $paginationHelper */
$paginationHelper = $view['knp_pagination'];

$view['slots']->set('title', $translator->trans('title.popup.index', [], 'popup'));
$view['slots']->set('titleSite', $translator->trans('popup.index.title', [], 'popup'));
$view['slots']->set('titleDesc', $translator->trans('popup.index.desc', [], 'popup'));
$view['slots']->set('titleIcon', '<i class="icon-popup-5 color-menu-template-extension"></i>');
$view['slots']->set('helpRightPanel', '');
?>
<?php $view['slots']->start('stylesheets'); ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/css/jquery.dataTables.min.css'); ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css'); ?>">
<?php $view['slots']->stop(); ?>
<?php $view['slots']->start('breadcrumbs'); ?>
<li><?php echo $view['translator']->trans('main-menu.template_extension'); ?></li>
<li><a href="<?php echo $view['router']->path('admin_popup_index'); ?>"><?php echo $translator->trans('breadcrumbs.popup.index', [], 'popup'); ?></a></li>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('body'); ?>
<div class="box">
    <div class="box-header bg-transparent">
        <div class="pull-right box-tools">
            <?php if ($view['security']->isGranted('ROLE_POPUP_EDIT')): ?>
                <a href="<?php echo $view['router']->path('admin_popup_new'); ?>" title="<?php echo $view['translator']->trans('popup.add', [], 'popup'); ?>" class="button tiny primary buttonAddNew">
                    <i class="icon-doc-add"></i><?php echo $view['translator']->trans('popup.add', [], 'popup'); ?>
                </a>
            <?php endif; ?>
        </div>
        <h3 class="box-title">
            <i class="icon-popup-5"></i> <span><?php echo $translator->trans('popup.index.subtitle', [], 'popup'); ?></span>
        </h3>
    </div>
    <div class="box-body" style="display: block;">
        <div class="row">
            <div class="columns tableResp">
                <table id="popupList" class="display" style="width: 100%;">
                    <thead>
                        <tr>
                            <th><?php echo $paginationHelper->sortable($popups, $translator->trans('popup.table.id', [], 'popup'), 'p.id'); ?></th>
                            <th><?php echo $paginationHelper->sortable($popups, $translator->trans('popup.table.title', [], 'popup'), 'p.title'); ?></th>
                            <th><?php echo $paginationHelper->sortable($popups, $translator->trans('popup.table.date_start', [], 'popup'), 'p.dateStart'); ?></th>
                            <th><?php echo $paginationHelper->sortable($popups, $translator->trans('popup.table.date_end', [], 'popup'), 'p.dateEnd'); ?></th>
                            <th><?php echo $paginationHelper->sortable($popups, $translator->trans('popup.table.duration', [], 'popup'), 'p.duration'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php /** @var \Admin\WicmsBundle\Entity\Popup $popup */
                    foreach ($popups as $popup): ?>
                        <tr>
                            <td><?php echo $popup->getId(); ?></td>
                            <td>
                                <?php echo $popup->getTitle(); ?>
                                <div class="buttonItemsBox">
                                    <div class="buttonsItems">
                                        <?php if ($view['security']->isGranted('ROLE_POPUP_EDIT')): ?>
                                            <a href="<?php echo $view['router']->path('admin_popup_edit', ['id' => $popup->getId()]); ?>" class=""><i class="icon-edit-1"></i><?php echo $translator->trans('Table.editButton'); ?></a> |
                                            <a href="<?php echo $view['router']->path('admin_popup_delete', ['id' => $popup->getId()]); ?>" class=""><i class="icon-cancel-circled-outline"></i><?php echo $translator->trans('Table.deleteButton'); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                            <td><?php echo $popup->getDateStartFormatted(); ?></td>
                            <td><?php echo $popup->getDateEndFormatted(); ?></td>
                            <td><?php echo $popup->getDuration(); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="medium-6 columns">
                <?php if ($view['security']->isGranted('ROLE_POPUP_EDIT')): ?>
                    <a href="<?php echo $view['router']->path('admin_popup_new'); ?>" title="<?php echo $translator->trans('popup.add', [], 'popup'); ?>" class="button primary newsListNew">
                        <i class="icon-doc-add"></i> <?php echo $translator->trans('popup.add', [], 'popup'); ?>
                    </a>
                <?php endif; ?>
            </div>
            <div class="medium-6 columns paginationBox">
                <?php echo $view->render('KnpPaginatorBundle/Pagination/per_page.html.php', [
                    'knp_pagination' => $popups,
                ]); ?>
                <?php echo $view['knp_pagination']->render($popups); ?>
            </div>
        </div>
    </div>
</div>
<script>var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';</script>
<?php $view['slots']->stop(); ?>

<?php $view['slots']->start('javascript'); ?>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/jquery.tooltipster.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/popup.js'); ?>"></script>
<?php $view['slots']->stop(); ?>
