<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_faq_question_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.faqQuestion.questionDelete')) ?>

<?php $view['slots']->start('stylesheets') ?>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/faq.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"/>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <?php echo $view['translator']->trans('main-menu.content'); ?>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_question_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.faq'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_faq_question_delete', array('id' => $question->getId())); ?>"><?php echo $view['translator']->trans('breadcrumbs.faqQuestion.questionDelete'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
   <?php echo $view['translator']->trans('faqQuestion.listSubTitle'); ?> - <?php echo $view['translator']->trans('faqQuestionDelete.subTitle'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
    <i class="icon-help-circled-1 color-menu-content"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('faqQuestionDelete.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('helpRightPanel') ?>

<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title">
            <i class="icon-doc-remove"></i>
            <span><?php echo $view['translator']->trans('faqQuestionDelete.listSubTitle'); ?> - <?php echo $question->getQuestion(); ?></span>
        </h3></div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong><?php echo $view['translator']->trans('faqQuestionDelete.dataQuestion'); ?></strong></p>

                <?php echo $view['form']->start($deleteForm); ?>
                <?php echo $view['form']->errors($deleteForm); ?>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($deleteForm['deleteQuestion']); ?>
                    <?php echo $view['form']->widget($deleteForm['deleteQuestion']); ?>
                </div>
                <p><?php echo $view['translator']->trans('faqQuestionDelete.dataQuestionSub'); ?>:<br>
                    <strong><?php echo $view['translator']->trans('faqQuestionNew.form.titleTitle'); ?></strong> <?php echo $question->getQuestion() ?><br>
                    <strong><?php echo $view['translator']->trans('faqQuestionNew.form.shortTitle'); ?></strong> <?php echo $question->getShortcut() ?><br>
                </p>
                <button type="submit" id="QuestionDeleteInput" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                    <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                </button>
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_faq_question_show', array('id' => $question->getId())); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
                <?php echo $view['form']->end($deleteForm); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/faq.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
