<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.recipient.recipientList')) ?>

<?php $view['slots']->start('stylesheets') ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.recipient.recipientList'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
Recipient group - delete
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-mail"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
Recipient group delete. Delete recipient group.
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<div class="box">
    <div class="box-header bg-transparent">
        <!-- tools box -->
        <h3 class="box-title">
            <i class="icon-doc-remove"></i>
            <span><?php echo $view['translator']->trans('sender.delete.boxTitle'); ?> - <?php echo $recipientGroup->getName(); ?></span>
        </h3></div>
    <!-- /.box-header -->
    <div class="box-body " style="display: block;">
        <div class="row">
            <div class="large-12 columns">
                <p><strong>Are you sure you want to remove this recipients group?</strong></p>

                <?php echo $view['form']->start($deleteForm); ?>
                <?php echo $view['form']->errors($deleteForm); ?>
                <div class="switch-admin">
                    <?php echo $view['form']->errors($deleteForm['delete']); ?>
                    <?php echo $view['form']->widget($deleteForm['delete']); ?>
                </div>
                <button type="submit" id="deleteButton" class="button alert tiny" value="<?php echo $view['translator']->trans('Form.delete'); ?>" disabled>
                    <i class="icon-cancel-circled"></i> <?php echo $view['translator']->trans('adminDelete.delete'); ?>
                </button>
                <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_recipient_group_show', array('id' => $recipientGroup->getId())); ?>">
                    <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.backShow'); ?>
                </a>
                <?php echo $view['form']->end($deleteForm); ?>
            </div>
        </div>
    </div>
</div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
<script>
    var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
</script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
