<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>

<?php $view['slots']->set('title', $view['translator']->trans('title.recipient.recipientList')) ?>

<?php $view['slots']->start('stylesheets') ?>
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/tip/tooltipster.css') ?>">
<link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>">
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a></li>
<li><a href="<?php echo $view['router']->path('wi_admin_newsletter_recipients_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.recipient.recipientList'); ?></a></li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
 Recipient group - List
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-mail"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
Recipient group list. Create new, delete or edit already existing recipient group.
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
<div class="row">
    <div class="large-12 columns">
        <div class="box">
            <div class="box-header bg-transparent">
                <div class="pull-right box-tools">
                    <span class="box-btn" data-toggle="dropdown-1">
                        <i class="icon-ellipsis-vert"></i>
                    </span>
                    <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="dropdown-1" data-dropdown data-close-on-click="true">
                        <ul class="no-bullet">
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                <li>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipient_group_new'); ?>"  title="<?php echo $view['translator']->trans('blockList.addNewBlock'); ?>">
                                        <span><i class="icon-folder-add"></i>Add new recipient group</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="pull-right box-tools">
                        <span>
                            <i class="icon-up-open collapseExpand" data-widget="collapse"></i>
                        </span>
                    </div>
                </div>
                <h3 class="box-title" data-widget="collapse"><i class="icon-help-circled"></i>
                    <span>Recipient groups</span>
                </h3>
            </div>
            <div class="box-body" style="display: block;">
                <div class="row">
                    <table>
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Name</th>
                                <th>Recipients</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($recipientGroups as $recipientGroup): ?>
                            <tr>
                                <td><?php echo $recipientGroup->getId(); ?></td>
                                <td>
                                    <a href="<?php echo $view['router']->path('wi_admin_newsletter_recipient_group_show', ['id' => $recipientGroup->getId()]); ?>">
                                        <?php echo $recipientGroup->getName(); ?>
                                    </a>
                                </td>
                                <td><?php echo $recipientGroup->getRecipientsCount(); ?></td>
                            </tr>
                        <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="large-2 columns"></div>
    <div class="large-10 columns">
        <div class="news-add-form">
            <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_index'); ?>">
                <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
            </a>
        </div>
    </div>
</div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
<script>
    var language = '<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/i18n/'.$view['request']->getLocale().'.json'); ?>';
</script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/jquery/dataTables/media/js/jquery.dataTables.min.js') ?>" type="text/javascript"></script>
<script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
