<?php
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\AssetsHelper $assets */
$assets = $view['assets'];
/** @var \Symfony\Bundle\SecurityBundle\Templating\Helper\SecurityHelper $security */
$security = $view['security'];
/** @var \Symfony\Bundle\FrameworkBundle\Templating\Helper\TranslatorHelper $translator */
$translator = $view['translator'];
/** @var \Admin\WicmsBundle\Templating\Helper\ConfigHelper $configHelper */
$configHelper = $view['config'];
?>
<!DOCTYPE html>
<html class="no-js" lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="noindex, nofollow">
    <title><?php echo $translator->trans('login.title'); ?></title>
    <link rel="shortcut icon" href="<?php echo $assets->getUrl('media/Admin/WiCMS3/img/WiCMS-favicon.png'); ?>">
    <link rel="stylesheet" href="<?php echo $assets->getUrl('media/Admin/WiCMS3/js/jquery/Foundation/foundation-sites/dist/css/foundation-float.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo $assets->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/css/Montserrat-Hairline.css'); ?>">
    <link rel="stylesheet" href="<?php echo $assets->getUrl('media/Admin/WiCMS3/css/login.css'); ?><?php echo $configHelper->getParameter('vStyle'); ?>">
</head>
<body>
<div class="inner-wrap">
    <div class="wrap-fluid">
        <div class="row columns">
            <div class="profile">
                <img src="<?php echo $assets->getUrl('media/Admin/WiCMS3/img/WiCMS-logo-white-200px.png'); ?>" alt="">
            </div>
        </div>
        <div class="loginWhite">
            <div class="row">
                <div class="columns text-center">
                    <h1><?php echo $translator->trans('login.nameWiCMS'); ?></h1>
                    <p class="text-center"><?php echo $translator->trans('login.infoWiCMS'); ?></p>
                    <hr>
                </div>
            </div>
            <div class="row">
                <div class="columns text-center formLogin">
                    <h3><?php echo $translator->trans('login.header'); ?></h3>
                    <div class="box float-center">
                        <div class="box-body " style="display: block;">
                            <div class="row">
                                <div class="large-12 columns">
                                    <div class="row">
                                        <div class="edumix-signup-panel">
                                            <p class="welcome"></p>
                                            <?php if ($error): ?>
                                                <div class="alert callout small"><?php echo $translator->trans($error->getMessage()); ?></div>
                                            <?php endif ?>
                                            <?php if ($app->getUser() && $security->isGranted('ROLE_USER')): ?>
                                                <div class="callout warning small">
                                                    <?php echo $translator->trans('login.loginUserFrontInfo'); ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if (! is_null($ip_blocked)): ?>
                                                <div class="callout warning small"><?php echo $translator->trans('login.attempts_error'); ?> <strong><span id="blocked-counter"></span></strong>.</div>
                                            <?php else: ?>
                                                <form action="<?php echo $view['router']->path('wi_admin_admin_login'); ?>" method="post">
                                                    <input type="hidden" name="_csrf_token" value="<?php echo $view['form']->csrfToken('authenticate'); ?>">
                                                    <div class="row column log-in-form">
                                                        <label>
                                                            <input data-tooltip aria-haspopup="true" class="has-tip left" data-disable-hover="false" tabindex="1" title="<?php echo $translator->trans('login.userDesc'); ?>" type="text" id="username" name="_username" class="float-center" value="<?php echo $last_username ?>" placeholder="<?php echo $translator->trans('login.user'); ?>" <?php echo ($app->getUser() && $security->isGranted('ROLE_USER')) ? 'disabled' : ''; ?>>
                                                        </label>
                                                        <div class="formPasswordShow">
                                                            <label>
                                                                <input data-tooltip aria-haspopup="true" class="has-tip left" data-disable-hover="false" tabindex="1" title="<?php echo $translator->trans('login.passDesc'); ?>" type="password" id="password" class="float-center" name="_password" placeholder="<?php echo $translator->trans('login.pass'); ?>" <?php echo ($app->getUser() && $security->isGranted('ROLE_USER')) ? 'disabled' : ''; ?>/>
                                                            </label>
                                                            <div class="passwordShowButton" id="show-password">
                                                                <i class="icon-eye"></i>
                                                                <i class="icon-eye-off hide"></i>
                                                            </div>
                                                        </div>
                                                        <p><input type="submit" class="button float-center" value="<?php echo $translator->trans('login.button'); ?>" <?php echo ($app->getUser() && $security->isGranted('ROLE_USER')) ? 'disabled' : ''; ?>></p>
                                                        <p class="text-center forgotPassword"><a href="<?php echo $view['router']->path('wi_admin_admin_forgot_password'); ?>"><?php echo $translator->trans('login.forgotPass'); ?></a></p>
                                                    </div>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="columns">
                    <hr>
                </div>
            </div>
            <div class="row infoBrowser">
                <div class="columns small-12 medium-6">
                    <h2><?php echo $translator->trans('login.correct'); ?></h2>
                    <p><?php echo $translator->trans('login.correctInfo'); ?></p>
                    <div class="rowInfoBrowser">
                        <div class="infoBrowserIcon">
                            <a href="https://www.mozilla.org/pl/firefox/new/" target="_blank" rel="nofollow">
                                <img src="<?php echo $browser['name'] == 'Firefox' ? $assets->getUrl('media/Admin/WiCMS3/img/firefoxActive.png') : $assets->getUrl('media/Admin/WiCMS3/img/firefox.png'); ?>" alt="Mozilla Firefox" class="firefox">
                            </a>
                            <a href="https://www.google.pl/chrome/" target="_blank" rel="nofollow">
                                <img src="<?php echo $browser['name'] == 'Chrome' ? $assets->getUrl('media/Admin/WiCMS3/img/chromeActive.png') : $assets->getUrl('media/Admin/WiCMS3/img/chrome.png'); ?>" alt="Google Chrome" class="chrome">
                            </a>
                            <small class="browserName"><?php echo $browser['name'].' '.$browser['version']; ?></small>
                        </div>
                        <div class="infoBrowserText text-left">
                            <div class="correctTest <?php echo $browser['name'] == 'Chrome' || $browser['name'] == 'Firefox' ? '' : 'hide'; ?>">
                                <i class="icon-ok-6"></i>
                                <p><?php echo $translator->trans('login.correctTest'); ?></p>
                            </div>
                            <div class="incorrectTest <?php echo $browser['name'] == 'Chrome' || $browser['name'] == 'Firefox' ? 'hide' : ''; ?>">
                                <i class="icon-attention-alt"></i>
                                <p><?php echo $translator->trans('login.incorrectTest'); ?></p>
                                <p class="incorrectTestInfo"><?php echo $translator->trans('login.incorrectTestInfo'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="columns small-12 medium-6 infoWebsite">
                    <h2><?php echo $translator->trans('login.infoWebsite'); ?></h2>
                    <div class="row">
                        <div class="columns">
                            <i class="icon-mobile-1"></i>
                            <p><strong><?php echo $translator->trans('login.responsiveLayout'); ?></strong><br><?php echo $translator->trans('login.responsiveLayoutInfo'); ?></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="columns">
                            <i class="icon-search"></i>
                            <p><strong><?php echo $translator->trans('login.seo'); ?></strong><br><?php echo $translator->trans('login.seoInfo'); ?></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="columns">
                            <i class="icon-pencil"></i>
                            <p><strong><?php echo $translator->trans('login.pages'); ?></strong><br><?php echo $translator->trans('login.pagesInfo'); ?></p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="columns">
                            <i class="icon-chart"></i>
                            <p><strong><?php echo $translator->trans('login.stats'); ?></strong><br><?php echo $translator->trans('login.statsInfo'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <footer>
            <div class="row">
                <div class="medium-6 columns profile-dol">
                    <a href="http://www.webimpuls.pl" title="<?php echo $translator->trans('footer.wi-link-title'); ?>" class="">
                        <img class="webimpulsLogo" src="<?php echo $assets->getUrl('media/Admin/WiCMS3/img/WEBimpuls-logo-2015-500px.png'); ?>" alt="<?php echo $translator->trans('footer.wi-img-alt'); ?>">
                    </a><br>
                    <a href="http://www.webimpuls.pl" title="<?php echo $translator->trans('footer.wi-link-title'); ?>" class="webimpuls"><?php echo $translator->trans('footer.Copyright'); ?></a>
                    <p><?php echo $translator->trans('footer.CopyrightInfo'); ?></p>
                </div>
                <div class="medium-6 columns profile-dol-right">
                    <h4><?php echo $translator->trans('login.moreInfo'); ?></h4>
                    <ul>
                        <li><a href="http://www.webimpuls.pl" title="<?php echo $translator->trans('footer.wi-link-title'); ?>"><span><?php echo $translator->trans('login.wi-link'); ?></span></a></li>
                        <li><a href="http://www.wicms.pl" title="<?php echo $translator->trans('login.wi-link-wicms'); ?>"><span><?php echo $translator->trans('login.wi-link-wi'); ?></span></a></li>
                    </ul>
                    <ul>
                        <li><a title="<?php echo $translator->trans('login.wi-link-help'); ?>"><span><?php echo $translator->trans('login.wi-link-help'); ?></span></a></li>
                    </ul>
                    <a href="<?php echo $view['router']->path('homepage'); ?>" class="button"><?php echo $translator->trans('login.showPage'); ?></a>
                </div>
            </div>
        </footer>
    </div>
</div>
<script src="<?php echo $assets->getUrl('media/Admin/WiCMS3/js/jquery.min.js'); ?>"></script>
<script src="<?php echo $assets->getUrl('media/Admin/WiCMS3/js/login.js'); ?>"></script>
<script src="<?php echo $assets->getUrl('media/Admin/WiCMS3/js/jquery/Fondamix/js/foundation.min.js'); ?>"></script>
<script>$(document).foundation();</script>
<?php if (! is_null($ip_blocked)): ?>
<script>
    var date = new Date("<?php echo $ip_blocked->getExpiredAt()->format('c'); ?>").getTime();
    var now = new Date("<?php echo (new \DateTime())->format('c'); ?>").getTime();

    setInterval(function () {
        now+=1000;
    }, 1000);

    var x = setInterval(function () {
        var distance = date - now;
        var hours = Math.floor(distance / (1000*60*60));
        var minutes = Math.floor((distance % (1000*60*60)) / (1000*60));
        var seconds = Math.floor((distance % (1000*60)) / 1000);
        document.getElementById('blocked-counter').innerHTML = pad(hours)+':'+pad(minutes)+':'+pad(seconds);

        if (distance <= 0) {
            clearInterval(x);
            document.getElementById('blocked-counter').innerHTML = '00:00:00';
        }
    }, 1000);

    function pad(input) {
        var s=input+"";while(s.length<2){s="0"+s}return s;
    }
</script>
<?php endif; ?>
</body>
</html>
