<?php $view->extend('::wicms.html.php') ?>
<?php $this->addGlobal('menuIsActive', $view['router']->path('wi_admin_newsletter_mainsite_index')); ?>


<?php $view['slots']->set('title', $view['translator']->trans('title.sender.senderShow')) ?>


<?php $view['slots']->start('stylesheets') ?>
    <link href="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/css/newsletter.css') ?><?php echo $view['config']->getParameter('vStyle'); ?>"  rel="stylesheet" type="text/css" />
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('breadcrumbs') ?>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_mainsite_index'); ?>"><?php echo $view['translator']->trans('breadcrumbs.newsletter.newsletter'); ?></a>
    </li>
    <li>
        <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_show', ['id' => $sender->getId()]); ?>"><?php echo $view['translator']->trans('breadcrumbs.sender.senderShow'); ?></a>
    </li>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('titleSite') ?>
    <?php echo $view['translator']->trans('sender.listTitle'); ?> - <?php echo $view['translator']->trans('sender.subTitleShow'); ?>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleIcon') ?>
<i class="icon-mail"></i>
<?php $view['slots']->stop() ?>
<?php $view['slots']->start('titleDesc') ?>
    <?php echo $view['translator']->trans('sender.show.desc'); ?>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('body') ?>
    <div class="box">
        <div class="box-header bg-transparent">
            <!-- tools box -->
            <div class="pull-right box-tools">
                <span class="box-btn" data-toggle="configShowNews-dropdown">
                    <i class="icon-ellipsis-vert"></i>
                </span>
                <div class="dropdown-pane configBoxButtons" data-position="bottom" data-alignment="center" id="configShowNews-dropdown" data-dropdown data-close-on-click="true">
                    <ul class="no-bullet">
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_edit', array('id' => $sender->getId())); ?>" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                                    <span><i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                        <li>
                            <?php if ($view['security']->isGranted('ROLE_NEWSLETTER_EDIT')): ?>
                                <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_delete', ['id' => $sender->getId()]); ?>">
                                    <span><i class="icon-cancel-circled"></i><?php echo $view['translator']->trans('sender.show.remove'); ?></span>
                                </a>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
            <h3 class="box-title">
                <span><?php echo $view['translator']->trans('show.details'); ?> - <?php echo $sender->getEmail(); ?></span>
            </h3>
        </div>
        <!-- /.box-header -->
        <div class="box-body " style="display: block;">
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sender.show.email'); ?>:</strong><br>
                        <strong><?php echo $view['translator']->trans('sender.show.name'); ?>:</strong><br>
                        <strong><?php echo $view['translator']->trans('sender.show.lang'); ?>:</strong><br>
                        <strong><?php echo $view['translator']->trans('sender.show.replayTo'); ?>:</strong>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="showShortDesc">
                        <p><?php echo $sender->getEmail(); ?><br>
                            <?php echo $sender->getName(); ?><br>
                            <?php echo $sender->getLang(); ?><br>
                            <?php echo $sender->getReplayTo(); ?>
                        </p>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <p><strong><?php echo $view['translator']->trans('sender.show.smtpLogin'); ?>:</strong><br>
                        <strong><?php echo $view['translator']->trans('sender.show.smtpHost'); ?>:</strong><br>
                        <strong><?php echo $view['translator']->trans('sender.show.smtpSSL'); ?>:</strong><br>
                        <strong><?php echo $view['translator']->trans('sender.show.smtpPort'); ?>:</strong>
                    </p>
                </div>
                <div class="large-10 columns">
                    <div class="showShortDesc">
                        <p><?php echo $sender->getSmtpLogin(); ?><br>
                            <?php echo $sender->getSmtpPassword(); ?><br>
                            <?php echo $sender->getSmtpHost(); ?><br>
                            <?php echo $sender->getSmtpSsl(); ?><br>
                            <?php echo $sender->getSmtpPort(); ?>
                        </p>
                    </div>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="large-2 columns">
                    <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                        <p><strong><?php echo $view['translator']->trans('sender.editB'); ?></strong></p>
                        <p><?php echo $view['translator']->trans('sender.editBDesc'); ?></p>
                    <?php endif; ?>
                </div>
                <div class="large-10 columns">
                    <?php if ($view['security']->isGranted('ROLE_FAQ_EDIT')): ?>
                        <a href="<?php echo $view['router']->path('wi_admin_newsletter_senders_edit', array('id' => $sender->getId())); ?>" class="button" title="<?php echo $view['translator']->trans('Form.edit'); ?>">
                            <i class="icon-edit"></i><?php echo $view['translator']->trans('Form.edit'); ?>
                        </a>
                    <?php endif; ?>
                    <a class="button secondary float-right" href="<?php echo $view['router']->path('wi_admin_newsletter_index', ['_fragment' => 'senders']); ?>">
                        <i class="icon-reply"></i> <?php echo $view['translator']->trans('Form.back'); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php $view['slots']->stop() ?>

<?php $view['slots']->start('javascript') ?>
    <script src="<?php echo $view['assets']->getUrl('media/Admin/WiCMS3/js/newsletter.js') ?>" type="text/javascript"></script>
<?php $view['slots']->stop() ?>
