<?php

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Kernel;
use Symfony\Component\Config\Loader\LoaderInterface;

class AppKernel extends Kernel
{
    public function registerBundles()
    {
        $bundles = [
            new Symfony\Bundle\FrameworkBundle\FrameworkBundle(),
            new Symfony\Bundle\SecurityBundle\SecurityBundle(),
            new Symfony\Bundle\TwigBundle\TwigBundle(),
            new Symfony\Bundle\MonologBundle\MonologBundle(),
            new Symfony\Bundle\SwiftmailerBundle\SwiftmailerBundle(),
            new Doctrine\Bundle\DoctrineBundle\DoctrineBundle(),
            new Sensio\Bundle\FrameworkExtraBundle\SensioFrameworkExtraBundle(),
            new Stof\DoctrineExtensionsBundle\StofDoctrineExtensionsBundle(),
            new Knp\Bundle\MenuBundle\KnpMenuBundle(),
            new Knp\Bundle\PaginatorBundle\KnpPaginatorBundle(),
            new FOS\JsRoutingBundle\FOSJsRoutingBundle(),
            new FOS\RestBundle\FOSRestBundle(),
            new Nelmio\ApiDocBundle\NelmioApiDocBundle(),
            new FOS\OAuthServerBundle\FOSOAuthServerBundle(),
            new WhiteOctober\BreadcrumbsBundle\WhiteOctoberBreadcrumbsBundle(),
            new Wi\Admin\CoreBundle\WiAdminCoreBundle(),
            new Wi\Admin\AdminBundle\WiAdminAdminBundle(),
            new Wi\Admin\NewsBundle\WiAdminNewsBundle(),
            new Wi\Admin\PageBundle\WiAdminPageBundle(),
            new Wi\Admin\MediaBundle\WiAdminMediaBundle(),
            new Wi\Admin\UserBundle\WiAdminUserBundle(),
            new Wi\Front\CoreBundle\WiFrontCoreBundle(),
            new Wi\Front\PageBundle\WiFrontPageBundle(),
            new Wi\Front\NewsBundle\WiFrontNewsBundle(),
            new Wi\Front\UserBundle\WiFrontUserBundle(),
            new Wi\Admin\FAQBundle\WiAdminFAQBundle(),
            new Wi\Admin\BlockBundle\WiAdminBlockBundle(),
            new Wi\Admin\MenuBundle\WiAdminMenuBundle(),
            new Wi\Admin\BannerBundle\WiAdminBannerBundle(),
            new Wi\Api\V1Bundle\WiApiV1Bundle(),
            new Wi\Admin\ContactBundle\WiAdminContactBundle(),
            new Wi\Front\ContactBundle\WiFrontContactBundle(),
            new Wi\Admin\LinkBundle\WiAdminLinkBundle(),
            new Wi\Front\LinkBundle\WiFrontLinkBundle(),
            new Wi\Admin\AdvertisingBundle\WiAdminAdvertisingBundle(),
            new Wi\Admin\NewsLetterBundle\WiAdminNewsLetterBundle(),
            new Wi\Admin\PdfBundle\WiAdminPdfBundle(),
            new Wi\Admin\DownloadBundle\WiAdminDownloadBundle(),
            new Wi\Front\DownloadBundle\WiFrontDownloadBundle(),
        ];

         if (in_array($this->getEnvironment(), ['dev', 'test'], true)) {
            $bundles[] = new Symfony\Bundle\DebugBundle\DebugBundle();
            $bundles[] = new Symfony\Bundle\WebProfilerBundle\WebProfilerBundle();
            $bundles[] = new Sensio\Bundle\DistributionBundle\SensioDistributionBundle();
            $bundles[] = new Doctrine\Bundle\FixturesBundle\DoctrineFixturesBundle();
            $bundles[] = new Sensio\Bundle\GeneratorBundle\SensioGeneratorBundle();
        }

        return $bundles;
    }

    public function getRootDir()
    {
        return __DIR__;
    }

    public function getCacheDir()
    {
        return dirname(__DIR__).'/var/cache/'.$this->getEnvironment();
    }

    public function getLogDir()
    {
        return dirname(__DIR__).'/var/logs';
    }

    public function registerContainerConfiguration(LoaderInterface $loader)
    {
        $loader->load(function (ContainerBuilder $container) {
            $container->setParameter('container.autowiring.strict_mode', true);
            $container->setParameter('container.dumper.inline_class_loader', true);

            $container->addObjectResource($this);
        });
        $loader->load($this->getRootDir().'/config/config_'.$this->getEnvironment().'.yml');
    }
}
