<!DOCTYPE html>
<html  class="no-js" lang="en">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="description" content="Error">
    <title>An Error Occurred: <?php echo $status_text; ?></title>
    <link rel="stylesheet" href="<?php echo $view['assets']->getUrl('media/Public/css/error.css'); ?>">
</head>
<body>

<section class="imgError text-center">
    <img src="<?php echo $view['assets']->getUrl('media/Public/img/errorPage/error500.svg'); ?>" alt="Error" class="">
    <div class="row">
        <div class="columns">
            <div class="errorTitle float-right">
                <h2>Błąd <?php echo $status_code; ?></h2>
            </div>
        </div>
    </div>
</section>
<section class="errorInfo">
    <div class="infoText float-center">
        <h1>Coś poszło nie tak.</h1>
        <p>
            <strong>Serwer zgłosił błąd 500 i nie mógł wykonać Twojej operacji ...</strong>
        </p>
        <p>
            ... ale nie martw się. Fajny z Ciebie gość, dlatego dajemy Ci <strong>dożywotnią gwarancję</strong>, dzięki czemu wszystkie usterki naprawimy bezpłatnie.
        </p>
    </div>
    <div class="infoText float-center infoMenu">
        <p>Ten błąd został już zgłoszony do działu technicznego WEBimpuls.</p>
        <p>Możesz nam pomóc zdiagnozować i naprawić problem zostawiając notatkę z informacjami o błędzie. Opisz co robiłeś w panelu WiCMS tuż przed wystąpieniem błędu i co mogło być jego przyczyną.</p>
        <div class="callout success successErrorInfo hide">
            Dziękujemy za przesłanie informacji. Pomoże nam ona w zdiagnozowaniu i naprawieniu błędu.
        </div>
        <label>
            <strong>Twoja notatka:</strong>
            <form action="">
                <textarea name="errorInfo" id="errorInfo" cols="15" rows="5"></textarea>
                <input type="hidden" name="id" id="idError" value="<?php echo get_defined_vars()['errorSendId']; ?>">
                <button type="button" class="button buttonCommentSend">
                    <span>Wyślij do działu IT</span>
                </button>
            </form>
        </label>
    </div>
    <div class="infoText float-center infoMenu">
        <h5>Co teraz możesz zrobić?</h5>
        <nav class="menuNav">
            <ul class="vertical menu accordion-menu menuFirst" data-accordion-menu>
                <li>
                    <a href="javascript:history.back()"><i class="fi-refresh"></i><span>Wróc wstecz i spróbuj jeszcze raz </span></a>
                </li>
                <li>
                    <a href="<?php echo $view['router']->path('wi_admin_admin_dashboard'); ?>" title="Strona Główna"><i class="fi-home"></i><span>Przejdź na stronę główną</span></a>
                </li>
            </ul>
            <ul class="vertical menu accordion-menu" data-accordion-menu>
                <li>
                    <a href="<?php echo $view['router']->path('wi_admin_pages_index'); ?>">
                        <span>Strony</span>
                    </a>
                </li>
                <li>
                    <a href="<?php echo $view['router']->path('wi_admin_news_index'); ?>">
                        <span>Newsy</span>
                    </a>
                </li>
                <li>
                    <a href="<?php echo $view['router']->path('wi_admin_media_index'); ?>">
                        <span>
                            Media
                        </span>
                    </a>
                </li>
                <li>
                    <a href="<?php echo $view['router']->path('wi_admin_blog_index'); ?>">
                        <span>Blog</span>
                    </a>
                </li>
                <li>
                    <a href="<?php echo $view['router']->path('wi_admin_contact_index'); ?>">
                        <span>Kontakt</span>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
    <div class="infoText float-center infoMenu">
        <ul class="accordion" data-accordion data-allow-all-closed="true">
            <li class="accordion-item" data-accordion-item>
                <!-- Accordion tab title -->
                <a href="#" class="accordion-title">Zobacz szczegóły techniczne błędu.</a>

                <!-- Accordion tab content: it would start in the open state due to using the `is-active` state class. -->
                <div class="accordion-content" data-tab-content>
                    <h5><?php echo $status_code; ?> <?php echo $status_text; ?></h5>
                    <p>
                        <small><strong>Message: </strong><?php echo get_defined_vars()['exception']->getMessage(); ?></small>
                    </p>
                    <p>
                        <small><strong>File (line): </strong>
                            <?php echo get_defined_vars()['exception']->getFile(); ?> (<?php echo get_defined_vars()['exception']->getLine(); ?>)
                        </small>
                    </p>
                    <p>
                        <small><strong>Trace:</strong></small>
                        <br>
                        <?php foreach (get_defined_vars()['exception']->getTrace() as $key=>$trace): ?>
                            <hr>
                            <small>
                                <strong><?php echo $key; ?>.</strong>
                                <?php if (strstr($trace['file'], 'vendor')): ?>
                                    <?php echo strstr($trace['file'], 'vendor'); ?>
                                <?php elseif (strstr($trace['file'], 'app')): ?>
                                    <?php echo strstr($trace['file'], 'app'); ?>
                                <?php elseif (strstr($trace['file'], 'src')): ?>
                                    <?php echo strstr($trace['file'], 'src'); ?>
                                <?php elseif (strstr($trace['file'], 'var')): ?>
                                    <?php echo strstr($trace['file'], 'var'); ?>
                                <?php elseif (strstr($trace['file'], 'web')): ?>
                                    <?php echo strstr($trace['file'], 'web'); ?>
                                <?php else: ?>
                                    <?php echo $trace['file']; ?>
                                <?php endif; ?>
                                <?php echo $trace['line'] ? '(Linia: ' . $trace['line'] . ')' : ''; ?>
                            <?php echo $trace['namespace'] ? '<br>Namespace: ' . $trace['namespace'] : ''; ?>
                            <?php echo $trace['short_class'] ? '<br>Short class: ' . $trace['short_class'] : ''; ?>
                            <?php echo $trace['class'] ? '<br>Class: ' . $trace['class'] : ''; ?>
                            <?php echo $trace['type'] ? '<br>Type: ' . $trace['type'] : ''; ?>
                            <?php echo $trace['function'] ? '<br>Function: ' . $trace['function'] : ''; ?>
                            </small><br>
                        <?php endforeach; ?>
                    </p>
                </div>
            </li>
            <!-- ... -->
        </ul>
    </div>
</section>
<script src="<?php echo $view['assets']->getUrl('bundles/fosjsrouting/js/router.js') ?>"></script>
<script src="<?php echo $view['router']->path('fos_js_routing_js', array('callback' => 'fos.Router.setData')) ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Public/vendor/FoundationXY/js/vendor/jquery.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Public/vendor/FoundationXY/js/vendor/what-input.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Public/vendor/FoundationXY/js/vendor/foundation.min.js'); ?>"></script>
<script src="<?php echo $view['assets']->getUrl('media/Public/js/error.js'); ?>"></script>
</body>
</html>