<?php

namespace Wi\Admin\AdminBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\AbstractFixture;
use Doctrine\Common\DataFixtures\OrderedFixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Wi\Admin\AdminBundle\Entity\Permission;

/**
 * Załadowanie roli do bazy danych.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class LoadPermissionData extends AbstractFixture implements OrderedFixtureInterface
{
    /**
     * {@inheritdoc}
     */
    public function load(ObjectManager $manager)
    {
        foreach ($this->getData() as $data) {
            $permission = $this->getPermission($data);

            // Przygotowanie do zapisu.
            $manager->persist($permission);
        }

        // Zapis.
        $manager->flush();
    }

    /**
     * {@inheritdoc}
     */
    public function getOrder()
    {
        return 8;
    }

    // ------------------------------------------------------------
    // Private functions.
    // ------------------------------------------------------------

    /**
     * Tablica danych.
     *
     * @return mixed[]
     */
    private function getData()
    {
        return [
            ['administrator' => 1, 'role' => 1],
            ['administrator' => 1, 'role' => 2],
            ['administrator' => 1, 'role' => 3],
            ['administrator' => 1, 'role' => 4],
            ['administrator' => 1, 'role' => 5],
            ['administrator' => 1, 'role' => 6],
            ['administrator' => 1, 'role' => 7],
            ['administrator' => 1, 'role' => 8],
            ['administrator' => 1, 'role' => 9],
            ['administrator' => 1, 'role' => 10],
            ['administrator' => 1, 'role' => 11],
            ['administrator' => 1, 'role' => 12],
            ['administrator' => 1, 'role' => 13],
            ['administrator' => 1, 'role' => 14],
            ['administrator' => 1, 'role' => 20],
            ['administrator' => 1, 'role' => 21],
            ['administrator' => 1, 'role' => 22],
            ['administrator' => 1, 'role' => 23],
            ['administrator' => 1, 'role' => 24],
            ['administrator' => 1, 'role' => 25],
            ['administrator' => 1, 'role' => 26],
            ['administrator' => 1, 'role' => 27],
            ['administrator' => 1, 'role' => 28],
            ['administrator' => 1, 'role' => 29],
            ['administrator' => 1, 'role' => 30],
            ['administrator' => 1, 'role' => 31],
            ['administrator' => 1, 'role' => 32],
            ['administrator' => 1, 'role' => 33],
            ['administrator' => 1, 'role' => 34],
            ['administrator' => 1, 'role' => 35],
            ['administrator' => 1, 'role' => 36],
            ['administrator' => 1, 'role' => 37],
            ['administrator' => 1, 'role' => 38],
            ['administrator' => 1, 'role' => 39],
            ['administrator' => 1, 'role' => 40],
            ['administrator' => 1, 'role' => 41],
        ];
    }

    /**
     * Tworzy nowy obiekt na podstawie przekazanej tablicy danych.
     *
     * @param array $data
     * @return \Wi\Admin\AdminBundle\Entity\Permission
     */
    private function getPermission(array $data)
    {
        return (new Permission())
            ->setAdministrator($this->getReference('ab-administrator-'.$data['administrator']))
            ->setRole($this->getReference('ab-role-'.$data['role']))
            ->setDateCreated(new \DateTime())
        ;
    }
}
