<?php

namespace Wi\Admin\AdminBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Wi\Admin\AdminBundle\Entity\Administrator;
use Wi\Admin\AdminBundle\Entity\LogAction;

/**
 * Log
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 *
 * @ORM\Table(
 *      name="admin_logs",
 *      indexes={
 *          @ORM\Index(name="IX_Logs_LogAction_id", columns={"logAction_id"}),
 *          @ORM\Index(name="IX_Logs_Administrator_id", columns={"administrator_id"})
 *      }
 * )
 * @ORM\Entity(repositoryClass="Wi\Admin\AdminBundle\Repository\LogRepository")
 */
class Log
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="timestamp", type="datetime")
     */
    private $timestamp;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="datetime", type="datetime")
     */
    private $datetime;

    /**
     * @var string
     *
     * @ORM\Column(name="ip", type="string", length=32)
     */
    private $ip;

    /**
     * @var string
     *
     * @ORM\Column(name="host", type="string", length=256, nullable=true)
     */
    private $host;

    /**
     * @var string
     *
     * @ORM\Column(name="agent", type="string", length=128, nullable=true)
     */
    private $agent;

    /**
     * @var Wi\Admin\AdminBundle\Entity\Administrator
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\AdminBundle\Entity\Administrator")
     * @ORM\JoinColumn(name="administrator_id", referencedColumnName="id", nullable=true)
     */
    private $administrator;

    /**
     * @var Wi\Admin\AdminBundle\Entity\LogAction
     *
     * @ORM\ManyToOne(targetEntity="Wi\Admin\AdminBundle\Entity\LogAction")
     * @ORM\JoinColumn(name="logAction_id", referencedColumnName="id", nullable=false)
     */
    private $logAction;

    /**
     * @var int
     *
     * @ORM\Column(name="object_id", type="integer", nullable=true)
     */
    private $objectId;

    /**
     * @var string
     *
     * @ORM\Column(name="info", type="text", nullable=true)
     */
    private $info;


    // ------------------------------------------------------------
    // Getters and setters methods.
    // ------------------------------------------------------------

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set timestamp
     *
     * @param \DateTime $timestamp
     * @return Log
     */
    public function setTimestamp($timestamp)
    {
        $this->timestamp = $timestamp;

        return $this;
    }

    /**
     * Get timestamp
     *
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }

    /**
     * Set datetime
     *
     * @param \DateTime $datetime
     * @return Log
     */
    public function setDatetime($datetime)
    {
        $this->datetime = $datetime;

        return $this;
    }

    /**
     * Get datetime
     *
     * @return \DateTime
     */
    public function getDatetime()
    {
        return $this->datetime;
    }

    /**
     * Set ip
     *
     * @param string $ip
     * @return Log
     */
    public function setIp($ip)
    {
        $this->ip = $ip;

        return $this;
    }

    /**
     * Get ip
     *
     * @return string
     */
    public function getIp()
    {
        return $this->ip;
    }

    /**
     * Set host
     *
     * @param string $host
     * @return Log
     */
    public function setHost($host)
    {
        $this->host = $host;

        return $this;
    }

    /**
     * Get host
     *
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * Set agent
     *
     * @param string $agent
     * @return Log
     */
    public function setAgent($agent)
    {
        $this->agent = $agent;

        return $this;
    }

    /**
     * Get agent
     *
     * @return string
     */
    public function getAgent()
    {
        return $this->agent;
    }

    /**
     * Set objectId
     *
     * @param integer $objectId
     * @return Log
     */
    public function setObjectId($objectId)
    {
        $this->objectId = $objectId;

        return $this;
    }

    /**
     * Get objectId
     *
     * @return int
     */
    public function getObjectId()
    {
        return $this->objectId;
    }

    /**
     * Set info
     *
     * @param string $info
     * @return Log
     */
    public function setInfo($info)
    {
        $this->info = $info;

        return $this;
    }

    /**
     * Get info
     *
     * @return string
     */
    public function getInfo()
    {
        return $this->info;
    }

    /**
     * Set administrator
     *
     * @param Administrator $administrator
     * @return Log
     */
    public function setAdministrator(Administrator $administrator = null)
    {
        $this->administrator = $administrator;

        return $this;
    }

    /**
     * Get administrator
     *
     * @return Administrator
     */
    public function getAdministrator()
    {
        return $this->administrator;
    }

    /**
     * Set logAction
     *
     * @param LogAction $logAction
     * @return Log
     */
    public function setLogAction(LogAction $logAction)
    {
        $this->logAction = $logAction;

        return $this;
    }

    /**
     * Get logAction
     *
     * @return LogAction
     */
    public function getLogAction()
    {
        return $this->logAction;
    }
}
