<?php

namespace Wi\Admin\AdminBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\AdminBundle\Entity\Administrator;

/**
 * Administrator Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class AdministratorType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('login', TextType::class, [
                'label' => 'adminData.login',
                'attr' => ['placeholder' => 'adminData.login'],
            ])
            ->add('password', RepeatedType::class, [
                'type' => PasswordType::class,
                'invalid_message' => 'adminData.errors.passwordRepeated',
                'invalid_message_parameters' => array('class' => 'alert callout small'),
                'first_options' => [
                    'label' => 'adminData.password',
                    'attr' => ['placeholder' => 'adminData.password'],
                ],
                'second_options' => [
                    'label' => 'adminAdd.repeatPass',
                    'attr' => ['placeholder' => 'adminAdd.repeatPass'],
                ],
                'required' => true,
            ])
            ->add('firstName', TextType::class, [
                'label' => 'adminData.firstName',
                'required' => false,
                'attr' => ['placeholder' => 'adminData.firstName'],

            ])
            ->add('lastName', TextType::class, [
                'label' => 'adminData.lastName',
                'required' => false,
                'attr' => ['placeholder' => 'adminData.lastName'],
            ])
            ->add('displayName', TextType::class, [
                'label' => 'adminData.displayName',
                'required' => false,
                'attr' => ['placeholder' => 'adminData.displayName'],
            ])
            ->add('email', EmailType::class, [
                'label' => 'adminData.email',
                'attr' => ['placeholder' => 'adminData.email'],
            ])
            ->add('job', TextType::class, [
                'label' => 'adminData.job',
                'required' => false,
                'attr' => ['placeholder' => 'adminData.job'],
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Administrator::class,
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_adminbundle_administrator';
    }


}
