<?php

namespace Wi\Admin\AdminBundle\Form;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Wi\Admin\AdminBundle\Entity\Administrator;

/**
 * Permission Type.
 *
 * @author Jakub Nowak <jakub.nowak@webimpuls.pl>
 * @copyright 2017 WEBimpuls Sp. z o.o.
 */
class PermissionType extends AbstractType
{
    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('roles', EntityType::class, [
                'class' => 'WiAdminAdminBundle:Role',
                'choice_label' => 'type',
                'choice_attr' => function ($val, $key, $index) use ($options) {
                    $attr = [];

                    if (! empty($options['data']->getPermissions())) {
                        foreach ($options['data']->getPermissions() as $permission) {
                            if ($permission->getRole()->getId() == $val->getId()) {
                                $attr['checked'] = true;
                            }
                        }
                    }

                    return $attr;
                },
                'expanded' => true,
                'label' => false,
                'multiple' => true,
                'mapped' => false,
            ])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Administrator::class,
        ));
    }

    /**
     * {@inheritdoc}
     */
    public function getBlockPrefix()
    {
        return 'wi_admin_adminbundle_permission';
    }


}
